/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YopCredentialsCache {
    private static Map<String, YopCredentials<?>> CREDENTIALS_MAP = Maps.newConcurrentMap();

    public static void put(String appKey, YopCredentials<?> credentials) {
        if (null == credentials || null == appKey) {
            return;
        }
        CREDENTIALS_MAP.put(appKey, credentials);
    }

    public static YopCredentials<?> get(String appKey) {
        if (null == appKey) {
            return null;
        }
        return CREDENTIALS_MAP.get(appKey);
    }

    public static void invalidate(String appKey) {
        if (null == appKey) {
            return;
        }
        CREDENTIALS_MAP.remove(appKey);
    }

    public static List<String> listKeys() {
        return new ArrayList<String>(CREDENTIALS_MAP.keySet());
    }
}

