/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStrategy;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.config.provider.file.YopCircuitBreakerConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCircuitBreakerRuleConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopDegradeRuleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopDegradeRuleHelper.class);
    private static volatile boolean initialized = false;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDegradeRule(List<URI> serverRoots, YopCircuitBreakerConfig circuitBreakerConfig) {
        if (initialized) {
            return;
        }
        Class<YopDegradeRuleHelper> clazz = YopDegradeRuleHelper.class;
        synchronized (YopDegradeRuleHelper.class) {
            if (initialized) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (CollectionUtils.isEmpty(serverRoots) || null == circuitBreakerConfig || CollectionUtils.isEmpty(circuitBreakerConfig.getRules())) {
                LOGGER.warn("Empty DegradeRule, Please Check Your Config And Try Again");
                initialized = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HashSet<DegradeRule> allRules = Sets.newHashSet();
            for (URI serverRoot : serverRoots) {
                String resource;
                if (null == serverRoot || DegradeRuleManager.hasConfig(resource = serverRoot.toString())) continue;
                allRules.addAll(YopDegradeRuleHelper.initDegradeRuleForResource(resource, circuitBreakerConfig));
            }
            if (CollectionUtils.isNotEmpty(allRules)) {
                DegradeRuleManager.loadRules(new ArrayList<DegradeRule>(allRules));
            }
            initialized = true;
            LOGGER.info("DegradeRule Inited, rules:{}", (Object)allRules);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static Set<DegradeRule> initDegradeRuleForResource(String resource, YopCircuitBreakerConfig circuitBreakerConfig) {
        HashSet<DegradeRule> result = Sets.newHashSet();
        if (CollectionUtils.isEmpty(circuitBreakerConfig.getRules())) {
            return result;
        }
        for (YopCircuitBreakerRuleConfig configRule : circuitBreakerConfig.getRules()) {
            DegradeRule degradeRule = new DegradeRule(resource).setGrade(configRule.getGrade()).setCount(configRule.getCount()).setStatIntervalMs(configRule.getStatIntervalMs()).setTimeWindow(configRule.getTimeWindow());
            if (CircuitBreakerStrategy.ERROR_COUNT.getType() != configRule.getGrade()) {
                degradeRule.setMinRequestAmount(configRule.getMinRequestAmount());
            } else {
                degradeRule.setMinRequestAmount(Double.valueOf(configRule.getCount()).intValue());
            }
            result.add(degradeRule);
        }
        return result;
    }

    public static boolean addDegradeRule(URI serverRoot, YopCircuitBreakerConfig circuitBreakerConfig) {
        if (null == serverRoot) {
            return false;
        }
        return YopDegradeRuleHelper.addDegradeRule(serverRoot.toString(), circuitBreakerConfig);
    }

    public static boolean addDegradeRule(String resource, YopCircuitBreakerConfig circuitBreakerConfig) {
        if (null == resource) {
            return false;
        }
        if (YopDegradeRuleHelper.existsResource(resource)) {
            return false;
        }
        Set<DegradeRule> rules = YopDegradeRuleHelper.initDegradeRuleForResource(resource, circuitBreakerConfig);
        boolean ruleAdded = YopDegradeRuleHelper.updateRulesForResource(resource, rules, false);
        if (YopConstants.SDK_DEBUG && ruleAdded) {
            LOGGER.info("DegradeRule Added, rules:{}", (Object)rules);
        }
        return ruleAdded;
    }

    public static boolean updateDegradeRule(String resource, YopCircuitBreakerConfig circuitBreakerConfig) {
        if (null == resource) {
            return false;
        }
        Set<DegradeRule> rules = YopDegradeRuleHelper.initDegradeRuleForResource(resource, circuitBreakerConfig);
        boolean ruleUpdated = YopDegradeRuleHelper.updateRulesForResource(resource, rules, true);
        if (YopConstants.SDK_DEBUG && ruleUpdated) {
            LOGGER.info("DegradeRule Updated, rules:{}", (Object)rules);
        }
        return ruleUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateRulesForResource(String resource, Set<DegradeRule> rules, boolean forceUpdate) {
        if (null == resource) {
            return false;
        }
        Set<DegradeRule> updateRules = CollectionUtils.isNotEmpty(rules) ? rules : null;
        rwl.writeLock().lock();
        try {
            if (DegradeRuleManager.hasConfig(resource) && !forceUpdate) {
                boolean bl = false;
                return bl;
            }
            boolean bl = DegradeRuleManager.setRulesForResource(resource, updateRules);
            return bl;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    private static boolean existsResource(String resource) {
        rwl.readLock().lock();
        try {
            boolean bl = DegradeRuleManager.hasConfig(resource);
            return bl;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    public static boolean removeDegradeRule(String resource) {
        if (null == resource) {
            return false;
        }
        if (!YopDegradeRuleHelper.existsResource(resource)) {
            return true;
        }
        boolean ruleRemoved = YopDegradeRuleHelper.updateRulesForResource(resource, null, true);
        if (YopConstants.SDK_DEBUG && ruleRemoved) {
            LOGGER.info("DegradeRule Removed, resource:{}", (Object)resource);
        }
        return ruleRemoved;
    }
}

