/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.config;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;

public class YopAppConfig
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String appKey;
    private Map<CertTypeEnum, Object> isvPrivateKeys = Maps.newHashMap();
    @Deprecated
    private List<YopCertConfig> isvEncryptKeys = Lists.newLinkedList();

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setIsvPrivateKey(List<YopCertConfig> isvPrivateKeys) {
        if (CollectionUtils.isEmpty(isvPrivateKeys)) {
            return;
        }
        for (YopCertConfig isvPrivateKey : isvPrivateKeys) {
            this.isvPrivateKeys.put(isvPrivateKey.getCertType(), YopCertParserFactory.getCertParser(YopCertCategory.PRIVATE, isvPrivateKey.getCertType()).parse(isvPrivateKey));
        }
    }

    public Map<CertTypeEnum, Object> getIsvPrivateKeys() {
        return this.isvPrivateKeys;
    }

    public PrivateKey loadPrivateKey(CertTypeEnum certType) {
        return (PrivateKey)this.isvPrivateKeys.get((Object)certType);
    }

    @Deprecated
    public List<YopCertConfig> getIsvEncryptKey() {
        return this.isvEncryptKeys;
    }

    @Deprecated
    public void setIsvEncryptKeyList(List<YopCertConfig> isvEncryptKeyList) {
        this.isvEncryptKeys = isvEncryptKeyList;
    }

    public static final class Builder {
        private String appKey;
        private List<YopCertConfig> isvPrivateKeys;
        @Deprecated
        private List<YopCertConfig> isvEncryptKeys;
        private YopFileSdkConfig yopFileSdkConfig;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder withIsvPrivateKeys(List<YopCertConfig> isvPrivateKeys) {
            this.isvPrivateKeys = isvPrivateKeys;
            return this;
        }

        @Deprecated
        public Builder withIsvEncryptKeys(List<YopCertConfig> isvEncryptKeys) {
            this.isvEncryptKeys = isvEncryptKeys;
            return this;
        }

        public Builder withSDKConfig(YopFileSdkConfig yopFileSdkConfig) {
            this.yopFileSdkConfig = yopFileSdkConfig;
            return this;
        }

        public YopAppConfig build() {
            if (null == this.appKey || StringUtils.equals(this.appKey, "default")) {
                this.appKey = this.yopFileSdkConfig.getAppKey();
            }
            YopAppConfig yopAppConfig = new YopAppConfig();
            yopAppConfig.setAppKey(this.appKey);
            if (CollectionUtils.isEmpty(this.isvPrivateKeys)) {
                this.isvPrivateKeys = this.yopFileSdkConfig.getIsvPrivateKey(this.appKey);
            }
            yopAppConfig.setIsvPrivateKey(this.isvPrivateKeys);
            if (CollectionUtils.isEmpty(this.isvEncryptKeys)) {
                this.isvEncryptKeys = this.yopFileSdkConfig.getIsvEncryptKey(this.appKey);
            }
            yopAppConfig.setIsvEncryptKeyList(this.isvEncryptKeys);
            return yopAppConfig;
        }
    }
}

