/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.config.provider.file;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.springframework.core.io.Resource;
import com.yeepay.shade.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import com.yeepay.yop.sdk.base.config.provider.YopFixedSdkConfigProvider;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.BeanUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YopFileSdkConfigProvider
extends YopFixedSdkConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopFileSdkConfigProvider.class);
    public static final String SDK_CONFIG_ENV_PROPERTY_KEY = "yop.sdk.config.env";
    public static final String SDK_CONFIG_DIR_PROPERTY_KEY = "yop.sdk.config.dir";
    public static final String SDK_CONFIG_FILE_PROPERTY_KEY = "yop.sdk.config.file";
    private static final String SDK_CONFIG_DIR = "config";
    private static final String DEFAULT_CONFIG_FILE = "config/yop_sdk_config_default.json";
    private Map<String, YopFileSdkConfig> sdkConfigs = Maps.newHashMap();

    @Override
    protected YopSdkConfig loadSdkConfig() {
        return this.convertYopSdkConfig(this.loadSdkConfig(""));
    }

    public YopFileSdkConfig loadSdkConfig(String appKey) {
        if (!this.sdkConfigs.containsKey(appKey = StringUtils.defaultIfBlank(appKey, "default"))) {
            this.sdkConfigs.computeIfAbsent(appKey, k -> this.doLoadYopFileSdkConfig((String)k));
        }
        return this.sdkConfigs.get(appKey);
    }

    private YopFileSdkConfig doLoadYopFileSdkConfig(String appKey) {
        String configDir = System.getProperty(SDK_CONFIG_DIR_PROPERTY_KEY);
        if (StringUtils.isNotEmpty(configDir)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.dir\uff0c\u503c\u4e3a\uff1a{}", (Object)configDir);
        } else {
            configDir = SDK_CONFIG_DIR;
        }
        String env = System.getProperty(SDK_CONFIG_ENV_PROPERTY_KEY);
        if (StringUtils.isNotEmpty(env)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.env\uff0c\u503c\u4e3a\uff1a{}", (Object)env);
            configDir = configDir + "/" + env;
        }
        String configFile = "";
        String file = System.getProperty(SDK_CONFIG_FILE_PROPERTY_KEY);
        if (StringUtils.isNotEmpty(file)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.file\uff0c\u503c\u4e3a\uff1a{}", (Object)file);
            configFile = !StringUtils.startsWithAny(file, "file://") ? configDir + "/" + file : file;
        } else {
            configFile = configDir + "/yop_sdk_config_" + appKey + ".json";
        }
        this.logger.info("\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6{}", (Object)configFile);
        YopFileSdkConfig customSdkConfig = this.loadSdkConfigFile(configFile);
        if (!StringUtils.equals(DEFAULT_CONFIG_FILE, configFile)) {
            YopFileSdkConfig defaultConfig = this.loadSdkConfigFile(DEFAULT_CONFIG_FILE);
            customSdkConfig = this.fillNullConfig(defaultConfig, customSdkConfig);
        }
        if (null == customSdkConfig) {
            throw new YopClientException("ConfigProblem, Can't load config, file:" + configFile);
        }
        return customSdkConfig;
    }

    private YopFileSdkConfig fillNullConfig(YopFileSdkConfig sourceBean, YopFileSdkConfig targetBean) {
        if (null == sourceBean) {
            return targetBean;
        }
        if (null == targetBean) {
            return sourceBean;
        }
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = targetBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field targetField;
            Field sourceField = sourceFields[i];
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic((targetField = targetFields[i]).getModifiers())) continue;
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (sourceField.get(sourceBean) == null || "serialVersionUID".equals(sourceField.getName()) || targetField.get(targetBean) != null) continue;
                targetField.set(targetBean, sourceField.get(sourceBean));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("error when fillNullConfig, ex:", e);
            }
        }
        return targetBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YopFileSdkConfig loadSdkConfigFile(String configFile) {
        YopFileSdkConfig sdkConfig = null;
        try {
            if (!StringUtils.startsWithAny(configFile, "file://")) {
                configFile = "classpath*:" + configFile;
            }
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(configFile);
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                StringBuilder script = new StringBuilder();
                BufferedReader bufferReader = null;
                try {
                    String tempString;
                    bufferReader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                    while ((tempString = bufferReader.readLine()) != null) {
                        script.append(tempString).append("\n");
                    }
                    StreamUtils.closeQuietly(bufferReader);
                }
                catch (IOException e) {
                    LOGGER.error("error when loadSdkConfigFile, ex:", e);
                }
                finally {
                    StreamUtils.closeQuietly(bufferReader);
                }
                if (script.length() <= 0) continue;
                YopFileSdkConfig sdkConfig0 = JsonUtils.loadFrom(script.toString(), YopFileSdkConfig.class);
                sdkConfig = BeanUtils.merge(sdkConfig0, sdkConfig);
            }
        }
        catch (IOException e) {
            LOGGER.error("error when loadSdkConfigFile, ex:", e);
        }
        return sdkConfig;
    }

    private YopSdkConfig convertYopSdkConfig(YopFileSdkConfig yopFileSdkConfig) {
        YopSdkConfig yopSdkConfig = new YopSdkConfig();
        yopSdkConfig.setServerRoot(yopFileSdkConfig.getServerRoot());
        yopSdkConfig.setYosServerRoot(yopFileSdkConfig.getYosServerRoot());
        yopSdkConfig.setPreferredServerRoots(yopFileSdkConfig.getPreferredServerRoots());
        yopSdkConfig.setPreferredYosServerRoots(yopFileSdkConfig.getPreferredYosServerRoots());
        yopSdkConfig.setSandboxServerRoot(yopFileSdkConfig.getSandboxServerRoot());
        yopSdkConfig.setTrustAllCerts(yopFileSdkConfig.getTrustAllCerts());
        yopSdkConfig.setProxy(yopFileSdkConfig.getProxy());
        yopSdkConfig.setRegion(yopFileSdkConfig.getRegion());
        yopSdkConfig.setYopHttpClientConfig(yopFileSdkConfig.getHttpClient());
        yopSdkConfig.setYopCertStore(yopFileSdkConfig.getYopCertStore());
        yopSdkConfig.setYopReportConfig(yopFileSdkConfig.getYopReportConfig());
        return yopSdkConfig;
    }

    public Map<String, YopFileSdkConfig> getSdkConfigs() {
        return this.sdkConfigs;
    }

    @Override
    public void removeConfig(String key) {
        this.sdkConfigs.remove(key);
    }
}

