/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.digest;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.digest.YopDigester;
import java.util.Map;
import java.util.ServiceLoader;

public class YopDigesterFactory {
    private static final Map<String, YopDigester> YOP_DIGESTER_MAP = Maps.newHashMap();

    public static void registerDigester(String alg, YopDigester digester) {
        YOP_DIGESTER_MAP.put(alg, digester);
    }

    public static YopDigester getDigester(String alg) {
        YopDigester yopDigester = YOP_DIGESTER_MAP.get(alg);
        if (null == yopDigester) {
            throw new YopClientException("ConfigProblem, YopDigester NotFound, alg:" + alg);
        }
        return yopDigester;
    }

    static {
        ServiceLoader<YopDigester> serviceLoader = ServiceLoader.load(YopDigester.class);
        for (YopDigester digester : serviceLoader) {
            for (String alg : digester.supportedAlgs()) {
                YOP_DIGESTER_MAP.put(alg, digester);
            }
        }
    }
}

