/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;

public class RsaEnhancer
extends AbstractEncryptOptionsEnhancer {
    private final String appKey;

    public RsaEnhancer(String appKey) {
        this.appKey = appKey;
    }

    @Override
    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        YopSymmetricCredentials sourceCredentials = (YopSymmetricCredentials)source.getCredentials();
        String credentialStr = sourceCredentials.getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        YopPlatformCredentials yopPlatformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getLatestCredentials(this.appKey, CertTypeEnum.RSA2048.getValue());
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("RSA").encryptToBase64(credentialBytes, new EncryptOptions(yopPlatformCredentials)));
        source.setCredentialsAlg("RSA");
        source.setCredentials(new YopSymmetricCredentials(this.appKey, credentialStr));
        source.enhance("YOP_PLATFORM_CERT_SERIAL_NO", "");
        return source;
    }
}

