/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import java.util.List;

public class Sm4Enhancer
extends AbstractEncryptOptionsEnhancer {
    private final String appKey;

    public Sm4Enhancer(String appKey) {
        this.appKey = appKey;
    }

    @Override
    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        List<YopCertConfig> mainKeys = YopCredentialsProviderRegistry.getProvider().getIsvEncryptKey(this.appKey);
        if (CollectionUtils.isEmpty(mainKeys)) {
            throw new YopClientException("ConfigProblem, IsvEncryptKey NotFound, appKey:" + this.appKey);
        }
        EncryptOptions mainKeyOptions = source.copy();
        String mainCredential = mainKeys.get(0).getValue();
        mainKeyOptions.setCredentials(new YopSymmetricCredentials(this.appKey, mainCredential));
        String credentialStr = ((YopSymmetricCredentials)source.getCredentials()).getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("SM4/CBC/PKCS5Padding").encryptToBase64(credentialBytes, mainKeyOptions));
        source.setCredentials(new YopSymmetricCredentials(this.appKey, credentialStr));
        source.setCredentialsAlg("SM4/CBC/PKCS5Padding");
        source.enhance("SM4_CERT_ID", mainCredential);
        return source;
    }
}

