/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class YopEncryptorFactory {
    private static final Map<String, YopEncryptor> YOP_ENCRYPTOR_MAP = Maps.newHashMap();

    public static void registerEncryptor(String encryptAlg, YopEncryptor encryptor) {
        YOP_ENCRYPTOR_MAP.put(encryptAlg, encryptor);
    }

    public static void registerEncryptor(List<String> encryptAlgs, YopEncryptor encryptor) {
        for (String encryptAlg : encryptAlgs) {
            YopEncryptorFactory.registerEncryptor(encryptAlg, encryptor);
        }
    }

    public static void registerEncryptor(Map<String, YopEncryptor> encryptors) {
        YOP_ENCRYPTOR_MAP.putAll(encryptors);
    }

    public static YopEncryptor getEncryptor(String encryptAlg) {
        YopEncryptor yopEncryptor = YOP_ENCRYPTOR_MAP.get(encryptAlg);
        if (null == yopEncryptor) {
            throw new YopClientException("ConfigProblem, YopEncryptor NotFound, encryptAlg:" + encryptAlg);
        }
        return yopEncryptor;
    }

    static {
        ServiceLoader<YopEncryptor> serviceLoader = ServiceLoader.load(YopEncryptor.class);
        for (YopEncryptor encryptor : serviceLoader) {
            for (String encryptAlg : encryptor.supportedAlgs()) {
                YOP_ENCRYPTOR_MAP.put(encryptAlg, encryptor);
            }
        }
    }
}

