/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.client.support.ClientConfigurationSupport;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import java.net.URI;
import java.util.Collections;
import java.util.stream.Collectors;

public abstract class AbstractServiceClientBuilder<SubClass extends AbstractServiceClientBuilder, ServiceInterfaceToBuild> {
    private YopCredentialsProvider credentialsProvider;
    private YopSdkConfigProvider yopSdkConfigProvider;
    private String endpoint;
    private String yosEndPoint;
    private String sandboxEndPoint;
    private ClientConfiguration clientConfiguration;

    public final ServiceInterfaceToBuild build() {
        if (null == this.yopSdkConfigProvider) {
            this.yopSdkConfigProvider = YopSdkConfigProviderRegistry.getProvider();
        }
        YopSdkConfig yopSdkConfig = this.yopSdkConfigProvider.getConfig();
        ClientParams clientParams = ClientParams.Builder.builder().withCredentialsProvider(this.credentialsProvider == null ? YopCredentialsProviderRegistry.getProvider() : this.credentialsProvider).withYopSdkConfigProvider(this.yopSdkConfigProvider).withClientConfiguration(this.clientConfiguration == null ? ClientConfigurationSupport.getClientConfiguration(yopSdkConfig) : this.clientConfiguration).withEndPoint(this.endpoint == null ? URI.create(StringUtils.defaultIfBlank(yopSdkConfig.getServerRoot(), "https://openapi.yeepay.com/yop-center")) : URI.create(this.endpoint)).withYosEndPoint(this.yosEndPoint == null ? URI.create(StringUtils.defaultIfBlank(yopSdkConfig.getYosServerRoot(), "https://yos.yeepay.com/yop-center")) : URI.create(this.yosEndPoint)).withPreferredEndPoint(CollectionUtils.isNotEmpty(yopSdkConfig.getPreferredServerRoots()) ? yopSdkConfig.getPreferredServerRoots().stream().map(URI::create).collect(Collectors.toList()) : Collections.emptyList()).withPreferredYosEndPoint(CollectionUtils.isNotEmpty(yopSdkConfig.getPreferredYosServerRoots()) ? yopSdkConfig.getPreferredYosServerRoots().stream().map(URI::create).collect(Collectors.toList()) : Collections.emptyList()).withSandboxEndPoint(this.sandboxEndPoint == null ? URI.create(StringUtils.defaultIfBlank(yopSdkConfig.getSandboxServerRoot(), "https://sandbox.yeepay.com/yop-center")) : URI.create(this.sandboxEndPoint)).withAuthorizationReqRegistry(this.authorizationReqRegistry()).build();
        return this.build(clientParams);
    }

    private SubClass getSubclass() {
        return (SubClass)this;
    }

    public SubClass withCredentialsProvider(YopCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.getSubclass();
    }

    public SubClass withYopSdkConfigProvider(YopSdkConfigProvider yopSdkConfigProvider) {
        this.yopSdkConfigProvider = yopSdkConfigProvider;
        return this.getSubclass();
    }

    public SubClass withClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this.getSubclass();
    }

    public SubClass withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this.getSubclass();
    }

    public SubClass withYosEndpoint(String yosEndpoint) {
        this.yosEndPoint = yosEndpoint;
        return this.getSubclass();
    }

    public SubClass withSandboxEndPoint(String sandboxEndPoint) {
        this.sandboxEndPoint = sandboxEndPoint;
        return this.getSubclass();
    }

    protected abstract AuthorizationReqRegistry authorizationReqRegistry();

    protected abstract ServiceInterfaceToBuild build(ClientParams var1);
}

