/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.shade.com.alibaba.csp.sentinel.Entry;
import com.yeepay.shade.com.alibaba.csp.sentinel.Tracer;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.BlockException;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopOauth2Credentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqSupport;
import com.yeepay.yop.sdk.base.auth.signer.YopSignerFactory;
import com.yeepay.yop.sdk.base.cache.EncryptOptionsCache;
import com.yeepay.yop.sdk.base.cache.YopDegradeRuleHelper;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.client.router.SimpleGateWayRouter;
import com.yeepay.yop.sdk.client.router.YopRouter;
import com.yeepay.yop.sdk.config.provider.file.YopCircuitBreakerConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopHostBlockException;
import com.yeepay.yop.sdk.exception.YopHostException;
import com.yeepay.yop.sdk.exception.YopHttpException;
import com.yeepay.yop.sdk.exception.YopUnknownException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpClientFactory;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RequestAnalyzer;
import com.yeepay.yop.sdk.invoke.AbstractUriResourceRouteInvoker;
import com.yeepay.yop.sdk.invoke.SimpleExceptionAnalyzer;
import com.yeepay.yop.sdk.invoke.SimpleUriRetryPolicy;
import com.yeepay.yop.sdk.invoke.UriResourceRouteInvoker;
import com.yeepay.yop.sdk.invoke.UriResourceRouteInvokerWrapper;
import com.yeepay.yop.sdk.invoke.model.AnalyzedException;
import com.yeepay.yop.sdk.invoke.model.ExceptionAnalyzer;
import com.yeepay.yop.sdk.invoke.model.UriResource;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.sentinel.YopSph;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandlerImpl
implements ClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientHandlerImpl.class);
    private final YopCredentialsProvider yopCredentialsProvider;
    private final AuthorizationReqRegistry authorizationReqRegistry;
    private final ClientConfiguration clientConfiguration;
    private final YopHttpClient client;
    private final GateWayRouter gateWayRouter;
    private final YopCircuitBreakerConfig circuitBreakerConfig;
    private final YopCircuitBreaker circuitBreaker;

    public ClientHandlerImpl(ClientHandlerParams handlerParams) {
        this.yopCredentialsProvider = handlerParams.getClientParams().getCredentialsProvider();
        this.authorizationReqRegistry = handlerParams.getClientParams().getAuthorizationReqRegistry();
        ServerRootSpace serverRootSpace = new ServerRootSpace(handlerParams.getClientParams().getEndPoint(), handlerParams.getClientParams().getYosEndPoint(), handlerParams.getClientParams().getPreferredEndPoint(), handlerParams.getClientParams().getPreferredYosEndPoint(), handlerParams.getClientParams().getSandboxEndPoint());
        this.gateWayRouter = new SimpleGateWayRouter(serverRootSpace);
        this.clientConfiguration = handlerParams.getClientParams().getClientConfiguration();
        this.client = this.buildHttpClient(handlerParams);
        this.circuitBreakerConfig = this.clientConfiguration.getCircuitBreakerConfig();
        this.circuitBreaker = new YopSentinelCircuitBreaker(serverRootSpace, this.circuitBreakerConfig);
    }

    private YopHttpClient buildHttpClient(ClientHandlerParams handlerParams) {
        YopHttpClient yopHttpClient = null == handlerParams ? YopHttpClientFactory.getDefaultClient() : YopHttpClientFactory.getClient(handlerParams.getClientParams().getClientConfiguration());
        return yopHttpClient;
    }

    @Override
    public <Input extends BaseRequest, Output extends BaseResponse> Output execute(ClientExecutionParams<Input, Output> executionParams) {
        ExecutionContext executionContext = this.getExecutionContext(executionParams);
        return (Output)((BaseResponse)new UriResourceRouteInvokerWrapper(new YopInvoker<Input, Output>(executionParams, executionContext, new SimpleExceptionAnalyzer(null != this.circuitBreakerConfig ? this.circuitBreakerConfig.getExcludeExceptions() : Collections.emptySet(), this.clientConfiguration.getRetryExceptions()), true), new SimpleUriRetryPolicy(this.clientConfiguration.getMaxRetryCount()), new YopRouter(this.gateWayRouter)).invoke());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Input extends BaseRequest, Output extends BaseResponse> Output doExecute(Request<Input> request, UriResourceRouteInvoker<ClientExecutionParams<Input, Output>, Output, ExecutionContext, AnalyzedException> invoker) throws YopClientException, YopHttpException, YopUnknownException {
        String result;
        Object Output2;
        URI serverRoot;
        long start;
        block10: {
            start = System.currentTimeMillis();
            serverRoot = request.getEndpoint();
            Throwable throwable = null;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Begin HttpInvoke, value:{}", (Object)serverRoot);
                }
                Output2 = this.client.execute(request, ((BaseRequest)request.getOriginalRequestObject()).getRequestConfig(), (ExecutionContext)invoker.getContext(), ((ClientExecutionParams)invoker.getInput()).getResponseHandler());
                result = "success";
                if (null == throwable) break block10;
            }
            catch (YopClientException clientError) {
                try {
                    throwable = clientError;
                    throw clientError;
                    catch (YopHttpException httpException) {
                        throwable = httpException;
                        throw httpException;
                    }
                    catch (Throwable ex) {
                        throwable = ex;
                        throw new YopUnknownException("UnExpected Error, ", ex);
                    }
                }
                catch (Throwable throwable2) {
                    String result2 = "success";
                    if (null != throwable) {
                        AnalyzedException analyzeResult = invoker.getExceptionAnalyzer().analyze(throwable, new Object[0]);
                        invoker.addException(analyzeResult);
                        result2 = "fail caused by " + analyzeResult.getExDetail();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Finish HttpInvoke, value:{}, result:{}, elapsed:{}.", serverRoot, result2, System.currentTimeMillis() - start);
                    }
                    throw throwable2;
                }
            }
            AnalyzedException analyzeResult = invoker.getExceptionAnalyzer().analyze(throwable, new Object[0]);
            invoker.addException(analyzeResult);
            result = "fail caused by " + analyzeResult.getExDetail();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finish HttpInvoke, value:{}, result:{}, elapsed:{}.", serverRoot, result, System.currentTimeMillis() - start);
        }
        return Output2;
    }

    private <Output extends BaseResponse, Input extends BaseRequest> ExecutionContext getExecutionContext(ClientExecutionParams<Input, Output> executionParams) {
        AuthorizationReq authorizationReq = this.getAuthorizationReq(executionParams.getInput());
        if (authorizationReq == null) {
            throw new YopClientException("no authenticate req defined");
        }
        YopRequestConfig requestConfig = ((BaseRequest)executionParams.getInput()).getRequestConfig();
        YopCredentials<?> credential = RequestAnalyzer.getCredentials(requestConfig, authorizationReq);
        YopEncryptor encryptor = null;
        Future<EncryptOptions> encryptOptions = null;
        if (RequestAnalyzer.isEncryptSupported(credential, requestConfig)) {
            encryptor = RequestAnalyzer.getEncryptor(requestConfig);
            encryptOptions = EncryptOptionsCache.loadEncryptOptions(credential.getAppKey(), requestConfig.getEncryptAlg(), requestConfig.getServerRoot());
        }
        ExecutionContext.Builder builder = ExecutionContext.Builder.anExecutionContext().withYopCredentials(credential).withEncryptor(encryptor).withEncryptOptions(encryptOptions).withSigner(YopSignerFactory.getSigner(authorizationReq.getSignerType())).withSignOptions(authorizationReq.getSignOptions());
        return builder.build();
    }

    private <Input extends BaseRequest> AuthorizationReq getAuthorizationReq(Input input) {
        String customAppKey = null;
        String customSecurityReq = null;
        YopCredentials<?> customCredentials = null;
        YopRequestConfig requestConfig = input.getRequestConfig();
        if (null != requestConfig) {
            customAppKey = requestConfig.getAppKey();
            customSecurityReq = requestConfig.getSecurityReq();
            customCredentials = requestConfig.getCredentials();
        }
        if (StringUtils.isNotBlank(customSecurityReq)) {
            return this.checkCustomSecurityReq(customSecurityReq);
        }
        if (null != customCredentials) {
            if (customCredentials instanceof YopOauth2Credentials) {
                return AuthorizationReqSupport.getAuthorizationReq("YOP-OAUTH2");
            }
            Object credential = customCredentials.getCredential();
            if (credential instanceof CredentialsItem) {
                return AuthorizationReqSupport.getAuthorizationReq(((CredentialsItem)credential).getCertType());
            }
        }
        List<CertTypeEnum> availableCerts = this.checkAvailableCerts(customAppKey);
        List<AuthorizationReq> authReqsForApi = this.checkAuthReqsByApi(input.getOperationId());
        return this.computeSecurityReq(availableCerts, authReqsForApi);
    }

    private AuthorizationReq computeSecurityReq(List<CertTypeEnum> availableCerts, List<AuthorizationReq> authReqsForApi) {
        for (AuthorizationReq authorizationReq : authReqsForApi) {
            if (!availableCerts.contains((Object)CertTypeEnum.parse(authorizationReq.getCredentialType()))) continue;
            return authorizationReq;
        }
        throw new YopClientException("can not computeSecurityReq, please check your cert config");
    }

    private List<AuthorizationReq> checkAuthReqsByApi(String operationId) {
        List<AuthorizationReq> apiAuthReqs = this.authorizationReqRegistry.getAuthorizationReq(operationId);
        if (CollectionUtils.isEmpty(apiAuthReqs)) {
            return AuthorizationReqSupport.getDefaultAuthReqsForApi();
        }
        return apiAuthReqs;
    }

    private AuthorizationReq checkCustomSecurityReq(String customSecurityReq) {
        AuthorizationReq authorizationReq = AuthorizationReqSupport.getAuthorizationReq(customSecurityReq);
        if (authorizationReq == null) {
            throw new YopClientException("unsupported customSecurityReq:" + customSecurityReq);
        }
        return authorizationReq;
    }

    private List<CertTypeEnum> checkAvailableCerts(String appKey) {
        List<CertTypeEnum> configPrivateCerts = this.yopCredentialsProvider.getSupportCertTypes(appKey);
        if (CollectionUtils.isEmpty(configPrivateCerts)) {
            throw new YopClientException("can not find private key for appKey:" + appKey);
        }
        return configPrivateCerts;
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    private class YopInvoker<Input extends BaseRequest, Output extends BaseResponse>
    extends AbstractUriResourceRouteInvoker<ClientExecutionParams<Input, Output>, Output, ExecutionContext, AnalyzedException> {
        public YopInvoker(ClientExecutionParams<Input, Output> executionParams, ExecutionContext executionContext, ExceptionAnalyzer<AnalyzedException> exceptionAnalyzer, boolean circuitBreaker) {
            this.setInput(executionParams);
            this.setContext(executionContext);
            this.setExceptionAnalyzer(exceptionAnalyzer);
            if (circuitBreaker) {
                this.enableCircuitBreaker();
            } else {
                this.disableCircuitBreaker();
            }
        }

        @Override
        public Output invoke() {
            Request request = ((ClientExecutionParams)this.getInput()).getRequestMarshaller().marshall(((ClientExecutionParams)this.getInput()).getInput());
            request.setEndpoint(this.getUriResource().getResource());
            if (this.isCircuitBreakerEnable() && null != ClientHandlerImpl.this.circuitBreaker && !BooleanUtils.isFalse(((BaseRequest)request.getOriginalRequestObject()).getRequestConfig().getEnableCircuitBreaker())) {
                return ClientHandlerImpl.this.circuitBreaker.execute(request, this);
            }
            return (Output)ClientHandlerImpl.this.doExecute(request, this);
        }
    }

    private class YopSentinelCircuitBreaker
    implements YopCircuitBreaker {
        public YopSentinelCircuitBreaker(ServerRootSpace serverRootSpace, YopCircuitBreakerConfig circuitBreakerConfig) {
            ArrayList<URI> serverRoots = Lists.newArrayList(serverRootSpace.getYosServerRoot(), serverRootSpace.getSandboxServerRoot());
            if (CollectionUtils.isNotEmpty(serverRootSpace.getPreferredEndPoint())) {
                serverRoots.addAll(serverRootSpace.getPreferredEndPoint());
            }
            if (CollectionUtils.isNotEmpty(serverRootSpace.getPreferredYosEndPoint())) {
                serverRoots.addAll(serverRootSpace.getPreferredYosEndPoint());
            }
            YopDegradeRuleHelper.initDegradeRule(serverRoots, circuitBreakerConfig);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <Input extends BaseRequest, Output extends BaseResponse> Output execute(Request<Input> request, UriResourceRouteInvoker<ClientExecutionParams<Input, Output>, Output, ExecutionContext, AnalyzedException> invoker) throws YopClientException, YopHttpException, YopUnknownException, YopHostException {
            BaseResponse baseResponse;
            boolean successInvoked;
            Entry entry;
            block13: {
                entry = null;
                successInvoked = false;
                UriResource uriResource = invoker.getUriResource();
                try {
                    if (!uriResource.isRetained()) {
                        String resource = uriResource.computeResourceKey();
                        YopDegradeRuleHelper.addDegradeRule(resource, ClientHandlerImpl.this.circuitBreakerConfig);
                        entry = YopSph.getInstance().entry(resource);
                    }
                    BaseResponse output = ClientHandlerImpl.this.doExecute(request, invoker);
                    successInvoked = true;
                    baseResponse = output;
                    if (null == uriResource) break block13;
                }
                catch (YopClientException | YopHttpException | YopUnknownException ex) {
                    try {
                        throw ex;
                        catch (Throwable ex2) {
                            if (BlockException.isBlockException(ex2)) {
                                YopHostBlockException hostBlockException = new YopHostBlockException("ServerRoot Blocked, ex:", ex2);
                                invoker.addException(invoker.getExceptionAnalyzer().analyze(hostBlockException, new Object[0]));
                                throw hostBlockException;
                            }
                            throw new YopUnknownException("UnExpected Error, ", ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (null != uriResource && null != uriResource.getCallback()) {
                            uriResource.getCallback().notify(successInvoked);
                        }
                        if (null != entry) {
                            Object lastException = invoker.getLastException();
                            if (!successInvoked && null != lastException && ((AnalyzedException)lastException).isNeedDegrade()) {
                                Tracer.trace(((AnalyzedException)lastException).getException());
                            }
                            entry.exit();
                        }
                        throw throwable;
                    }
                }
                if (null != uriResource.getCallback()) {
                    uriResource.getCallback().notify(successInvoked);
                }
            }
            if (null != entry) {
                Object lastException = invoker.getLastException();
                if (!successInvoked && null != lastException && ((AnalyzedException)lastException).isNeedDegrade()) {
                    Tracer.trace(((AnalyzedException)lastException).getException());
                }
                entry.exit();
            }
            return (Output)baseResponse;
        }
    }

    private static interface YopCircuitBreaker {
        public <Input extends BaseRequest, Output extends BaseResponse> Output execute(Request<Input> var1, UriResourceRouteInvoker<ClientExecutionParams<Input, Output>, Output, ExecutionContext, AnalyzedException> var2);
    }
}

