/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class ClientParams {
    private final URI endPoint;
    private final URI yosEndPoint;
    private final List<URI> preferredEndPoint;
    private final List<URI> preferredYosEndPoint;
    private final URI sandboxEndPoint;
    private final ClientConfiguration clientConfiguration;
    private final AuthorizationReqRegistry authorizationReqRegistry;
    private final YopCredentialsProvider credentialsProvider;
    private final YopSdkConfigProvider yopSdkConfigProvider;

    private ClientParams(URI endPoint, URI yosEndPoint, URI sandboxEndPoint, ClientConfiguration clientConfiguration, AuthorizationReqRegistry authorizationReqRegistry, YopCredentialsProvider credentialsProvider, YopSdkConfigProvider yopSdkConfigProvider) {
        this.endPoint = endPoint;
        this.yosEndPoint = yosEndPoint;
        this.preferredEndPoint = Collections.emptyList();
        this.preferredYosEndPoint = Collections.emptyList();
        this.sandboxEndPoint = sandboxEndPoint;
        this.clientConfiguration = clientConfiguration;
        this.authorizationReqRegistry = authorizationReqRegistry;
        this.credentialsProvider = credentialsProvider;
        this.yopSdkConfigProvider = yopSdkConfigProvider;
    }

    private ClientParams(URI endPoint, URI yosEndPoint, List<URI> preferredEndPoint, List<URI> preferredYosEndPoint, URI sandboxEndPoint, ClientConfiguration clientConfiguration, AuthorizationReqRegistry authorizationReqRegistry, YopCredentialsProvider credentialsProvider, YopSdkConfigProvider yopSdkConfigProvider) {
        this.endPoint = endPoint;
        this.yosEndPoint = yosEndPoint;
        this.preferredEndPoint = preferredEndPoint;
        this.preferredYosEndPoint = preferredYosEndPoint;
        this.sandboxEndPoint = sandboxEndPoint;
        this.clientConfiguration = clientConfiguration;
        this.authorizationReqRegistry = authorizationReqRegistry;
        this.credentialsProvider = credentialsProvider;
        this.yopSdkConfigProvider = yopSdkConfigProvider;
    }

    public URI getEndPoint() {
        return this.endPoint;
    }

    public URI getYosEndPoint() {
        return this.yosEndPoint;
    }

    public List<URI> getPreferredEndPoint() {
        return this.preferredEndPoint;
    }

    public List<URI> getPreferredYosEndPoint() {
        return this.preferredYosEndPoint;
    }

    public URI getSandboxEndPoint() {
        return this.sandboxEndPoint;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public AuthorizationReqRegistry getAuthorizationReqRegistry() {
        return this.authorizationReqRegistry;
    }

    public YopCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public YopSdkConfigProvider getYopSdkConfigProvider() {
        return this.yopSdkConfigProvider;
    }

    public static final class Builder {
        private URI endPoint;
        private URI yosEndPoint;
        private List<URI> preferredEndPoint;
        private List<URI> preferredYosEndPoint;
        private URI sandboxEndPoint;
        private ClientConfiguration clientConfiguration;
        private AuthorizationReqRegistry authorizationReqRegistry;
        private YopCredentialsProvider credentialsProvider;
        private YopSdkConfigProvider yopSdkConfigProvider;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withEndPoint(URI endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder withYosEndPoint(URI yosEndPoint) {
            this.yosEndPoint = yosEndPoint;
            return this;
        }

        public Builder withPreferredEndPoint(List<URI> preferredEndPoint) {
            this.preferredEndPoint = preferredEndPoint;
            return this;
        }

        public Builder withPreferredYosEndPoint(List<URI> preferredYosEndPoint) {
            this.preferredYosEndPoint = preferredYosEndPoint;
            return this;
        }

        public Builder withSandboxEndPoint(URI sandboxEndPoint) {
            this.sandboxEndPoint = sandboxEndPoint;
            return this;
        }

        public Builder withClientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder withAuthorizationReqRegistry(AuthorizationReqRegistry authorizationReqRegistry) {
            this.authorizationReqRegistry = authorizationReqRegistry;
            return this;
        }

        public Builder withCredentialsProvider(YopCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withYopSdkConfigProvider(YopSdkConfigProvider yopSdkConfigProvider) {
            this.yopSdkConfigProvider = yopSdkConfigProvider;
            return this;
        }

        public ClientParams build() {
            return new ClientParams(this.endPoint, this.yosEndPoint, this.preferredEndPoint, this.preferredYosEndPoint, this.sandboxEndPoint, this.clientConfiguration, this.authorizationReqRegistry, this.credentialsProvider, this.yopSdkConfigProvider);
        }
    }
}

