/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Queues;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.metric.YopFailureItem;
import com.yeepay.yop.sdk.client.metric.YopFailureList;
import com.yeepay.yop.sdk.client.metric.YopStatus;
import com.yeepay.yop.sdk.client.metric.event.host.YopHostRequestEvent;
import com.yeepay.yop.sdk.client.metric.report.AbstractYopReport;
import com.yeepay.yop.sdk.client.metric.report.YopRemoteReporter;
import com.yeepay.yop.sdk.client.metric.report.YopReport;
import com.yeepay.yop.sdk.client.metric.report.YopReporter;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostRequestPayload;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostRequestReport;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.file.YopReportConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientReporter.class);
    private static final YopReporter REMOTE_REPORTER = YopRemoteReporter.INSTANCE;
    private static final ConcurrentMap<String, AtomicReference<YopHostRequestReport>> YOP_HOST_REQUEST_COLLECTION = new ConcurrentHashMap<String, AtomicReference<YopHostRequestReport>>();
    private static final Set<String> EXCLUDE_REPORT_RESOURCES = Sets.newHashSet("/rest/v1.0/yop/client/report");
    private static final Deque<YopReport> YOP_HOST_REQUEST_QUEUE;
    private static final ThreadPoolExecutor COLLECT_POOL;
    private static final int REPORT_INTERVAL_MS;
    private static final int STAT_INTERVAL_MS;
    private static final int MAX_QUEUE_SIZE;
    private static final int MAX_PACKET_SIZE;
    private static final int MAX_FAIL_COUNT;
    private static final int MAX_FAIL_COUNT_PER_EX;
    private static final int MAX_ELAPSED_MS;
    private static final boolean ENABLE_REPORT;
    private static final boolean ENABLE_SUCCESS_REPORT;
    private static volatile boolean CLOSED;

    private ClientReporter() {
    }

    private static void startSenderThread() {
        Thread reportSendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!CLOSED) {
                    try {
                        ClientReporter.sendHostReport();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Unexpected Error, ex:", t);
                    }
                    try {
                        Thread.sleep(REPORT_INTERVAL_MS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        reportSendThread.setName("client-report-sender");
        reportSendThread.setDaemon(true);
        reportSendThread.start();
    }

    private static void startSweeperThread() {
        Thread reportSweeperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!CLOSED) {
                    try {
                        ClientReporter.sweepReports();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Unexpected Error, ex:", t);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        reportSweeperThread.setName("client-report-sweeper");
        reportSweeperThread.setDaemon(true);
        reportSweeperThread.start();
    }

    private static void sweepReports() {
        Set collectReports = YOP_HOST_REQUEST_COLLECTION.keySet();
        if (CollectionUtils.isEmpty(collectReports)) {
            return;
        }
        for (String reportKey : collectReports) {
            AtomicReference collectReport = (AtomicReference)YOP_HOST_REQUEST_COLLECTION.get(reportKey);
            if (null == collectReport) continue;
            ClientReporter.checkAndReport(reportKey, (YopHostRequestReport)collectReport.get());
        }
    }

    private static void checkAndReport(String reportKey, YopHostRequestReport yopHostRequestReport) {
        AtomicReference removed;
        AbstractYopReport reportToBeQueue = null;
        if (ClientReporter.needReport(new Date(), yopHostRequestReport) && null != (removed = (AtomicReference)YOP_HOST_REQUEST_COLLECTION.remove(reportKey))) {
            reportToBeQueue = (YopHostRequestReport)removed.get();
        }
        if (null != reportToBeQueue) {
            reportToBeQueue.setEndDate(new Date());
            ClientReporter.syncReportToQueue(reportToBeQueue);
        }
    }

    public static void syncReportToQueue(YopReport report) {
        while (!YOP_HOST_REQUEST_QUEUE.offer(report)) {
            YopReport oldReport = YOP_HOST_REQUEST_QUEUE.poll();
            if (oldReport == null) continue;
            LOGGER.info("Discard Old ReportEvent, value:{}", (Object)oldReport);
        }
    }

    public static void asyncReportToQueue(YopReport report) {
        COLLECT_POOL.submit(() -> ClientReporter.syncReportToQueue(report));
    }

    public static void asyncReportToQueue(YopReport report, ThreadPoolExecutor executor) {
        executor.submit(() -> ClientReporter.syncReportToQueue(report));
    }

    public static void reportHostRequest(YopHostRequestEvent<?> newEvent) {
        try {
            if (!ENABLE_REPORT) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore ReportEvent, value:{}", (Object)newEvent);
                }
                return;
            }
            if (!ENABLE_SUCCESS_REPORT && YopStatus.SUCCESS.equals((Object)newEvent.getStatus())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore Success ReportEvent, value:{}", (Object)newEvent);
                }
                return;
            }
            if (StringUtils.isBlank(newEvent.getServerResource()) || EXCLUDE_REPORT_RESOURCES.contains(newEvent.getServerResource())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore ReportEvent For Resource Excluded, value:{}", (Object)newEvent);
                }
                return;
            }
            ClientReporter.collectEvents(newEvent);
        }
        catch (Exception exception) {
            LOGGER.error("Error Handle ReportEvent, value:" + newEvent, exception);
        }
    }

    private static void collectEvents(YopHostRequestEvent<?> event) {
        if (null == event) {
            return;
        }
        if (CLOSED) {
            return;
        }
        COLLECT_POOL.submit(new CollectTask(event));
    }

    private static void sendHostReport() throws InterruptedException {
        YopReport report;
        LinkedList<YopReport> reports = Lists.newLinkedList();
        int packetSize = 0;
        while (packetSize++ < MAX_PACKET_SIZE && null != (report = YOP_HOST_REQUEST_QUEUE.poll())) {
            reports.add(report);
        }
        if (CollectionUtils.isEmpty(reports)) {
            return;
        }
        ClientReporter.sendWithRetry(reports);
    }

    private static void sendWithRetry(List<YopReport> reports) {
        try {
            REMOTE_REPORTER.batchReport(reports);
        }
        catch (Exception ex) {
            LOGGER.warn("Remote Report Fail, exType:{}, exMsg:{}, But Will Retry.", (Object)ex.getClass().getCanonicalName(), (Object)StringUtils.defaultString(ex.getMessage()));
            ClientReporter.tryEnqueue(reports);
        }
    }

    private static void tryEnqueue(List<YopReport> reports) {
        if (CollectionUtils.isEmpty(reports)) {
            return;
        }
        for (int i = reports.size() - 1; i >= 0; --i) {
            try {
                YOP_HOST_REQUEST_QUEUE.push(reports.get(i));
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("Report ReEnqueue Fail, exType:{}, exMsg:{}, ", (Object)ex.getClass().getCanonicalName(), (Object)StringUtils.defaultString(ex.getMessage()));
            }
        }
    }

    private static boolean needReport(Date currentTime, YopHostRequestReport report) {
        if (null == report) {
            return false;
        }
        YopHostRequestPayload payload = report.getPayload();
        Date beginTime = report.getBeginDate();
        int failCount = payload.getFailCount();
        long maxElapsedMillis = payload.getMaxElapsedMillis();
        List<YopFailureList> failDetails = payload.getFailDetails();
        if (currentTime.getTime() - beginTime.getTime() >= (long)STAT_INTERVAL_MS) {
            return true;
        }
        if (failCount >= MAX_FAIL_COUNT) {
            return true;
        }
        if (maxElapsedMillis >= (long)MAX_ELAPSED_MS) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(failDetails)) {
            for (YopFailureList failDetail : failDetails) {
                if (CollectionUtils.size(failDetail.getOccurDate()) < MAX_FAIL_COUNT_PER_EX) continue;
                return true;
            }
        }
        return false;
    }

    public static void close() {
        try {
            CLOSED = true;
        }
        catch (Exception exception) {
            LOGGER.error("Error When Close ClientReporter", exception);
        }
    }

    public static void open() {
        try {
            CLOSED = false;
        }
        catch (Exception exception) {
            LOGGER.error("Error When Open ClientReporter", exception);
        }
    }

    static {
        CLOSED = false;
        YopSdkConfig sdkConfig = YopSdkConfigProviderRegistry.getProvider().getConfig();
        if (null == sdkConfig) {
            throw new YopClientException("Sdk Config Not Found");
        }
        YopReportConfig yopReportConfig = sdkConfig.getYopReportConfig();
        if (null != yopReportConfig) {
            ENABLE_REPORT = yopReportConfig.isEnable();
            ENABLE_SUCCESS_REPORT = yopReportConfig.isEnableSuccessReport();
            REPORT_INTERVAL_MS = yopReportConfig.getSendIntervalMs();
            STAT_INTERVAL_MS = yopReportConfig.getStatIntervalMs();
            MAX_QUEUE_SIZE = yopReportConfig.getMaxQueueSize();
            MAX_PACKET_SIZE = yopReportConfig.getMaxPacketSize();
            MAX_FAIL_COUNT = yopReportConfig.getMaxFailCount();
            MAX_FAIL_COUNT_PER_EX = yopReportConfig.getMaxFailCountPerEx();
            MAX_ELAPSED_MS = yopReportConfig.getMaxElapsedMs();
            if (CollectionUtils.isNotEmpty(yopReportConfig.getExcludeResources())) {
                EXCLUDE_REPORT_RESOURCES.addAll(yopReportConfig.getExcludeResources());
            }
        } else {
            ENABLE_REPORT = true;
            ENABLE_SUCCESS_REPORT = false;
            REPORT_INTERVAL_MS = 3000;
            STAT_INTERVAL_MS = 5000;
            MAX_QUEUE_SIZE = 500;
            MAX_PACKET_SIZE = 50;
            MAX_FAIL_COUNT = 10;
            MAX_FAIL_COUNT_PER_EX = 5;
            MAX_ELAPSED_MS = 15000;
        }
        YOP_HOST_REQUEST_QUEUE = new LinkedBlockingDeque<YopReport>(MAX_QUEUE_SIZE);
        COLLECT_POOL = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, Queues.newLinkedBlockingQueue(MAX_QUEUE_SIZE), new ThreadFactoryBuilder().setNameFormat("client-report-event-collector-%d").setDaemon(true).build(), new ThreadPoolExecutor.DiscardOldestPolicy());
        ClientReporter.startSweeperThread();
        ClientReporter.startSenderThread();
    }

    private static class CollectTask
    implements Runnable {
        private final YopHostRequestEvent<?> event;

        public CollectTask(YopHostRequestEvent<?> event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                YopHostRequestReport current;
                String appKey = this.event.getAppKey();
                String serverHost = this.event.getServerHost();
                String serverIp = this.event.getServerIp();
                long elapsedMillis = this.event.getElapsedMillis();
                int successCount = 0;
                int retrySuccessCount = 0;
                int failCount = 0;
                YopFailureItem failDetail = null;
                if (YopStatus.SUCCESS.equals((Object)this.event.getStatus())) {
                    successCount = 1;
                    if (this.event.isRetry()) {
                        retrySuccessCount = 1;
                    }
                } else {
                    failCount = 1;
                    failDetail = (YopFailureItem)this.event.getData();
                }
                String reportKey = StringUtils.joinWith("###", appKey, serverHost, serverIp);
                AtomicReference reportReference = YOP_HOST_REQUEST_COLLECTION.computeIfAbsent(reportKey, p -> new AtomicReference());
                YopHostRequestReport update = new YopHostRequestReport();
                YopHostRequestPayload payload = new YopHostRequestPayload();
                payload.setAppKey(appKey);
                payload.setServerIp(serverIp);
                payload.setServerHost(serverHost);
                update.setPayload(payload);
                do {
                    if (null == (current = (YopHostRequestReport)reportReference.get())) {
                        payload.setSuccessCount(successCount);
                        payload.setRetrySuccessCount(retrySuccessCount);
                        payload.setFailCount(failCount);
                        payload.setMinElapsedMillis(elapsedMillis);
                        payload.setMaxElapsedMillis(elapsedMillis);
                        payload.setAvgElapsedMillis(elapsedMillis);
                        payload.setFailDetails(Lists.newLinkedList());
                        if (null == failDetail) continue;
                        YopFailureList yopFailDetail = new YopFailureList(failDetail.getExType(), failDetail.getExMsg());
                        yopFailDetail.getOccurDate().add(failDetail.getOccurDate());
                        payload.getFailDetails().add(yopFailDetail);
                        continue;
                    }
                    update.setBeginDate(current.getBeginDate());
                    YopHostRequestPayload oldPayload = current.getPayload();
                    payload.setSuccessCount(oldPayload.getSuccessCount() + successCount);
                    payload.setRetrySuccessCount(oldPayload.getRetrySuccessCount() + retrySuccessCount);
                    payload.setFailCount(oldPayload.getFailCount() + failCount);
                    payload.setMinElapsedMillis(Math.min(elapsedMillis, oldPayload.getMinElapsedMillis()));
                    payload.setMaxElapsedMillis(Math.max(elapsedMillis, oldPayload.getMaxElapsedMillis()));
                    payload.setAvgElapsedMillis((oldPayload.getAvgElapsedMillis() * (long)oldPayload.getTotalCount() + elapsedMillis) / (long)(oldPayload.getTotalCount() + 1));
                    payload.setFailDetails(oldPayload.cloneFailDetails());
                    YopFailureItem failDetailItem = failDetail;
                    if (null == failDetail) continue;
                    Optional<YopFailureList> yopFailDetail = payload.getFailDetails().stream().filter(p -> StringUtils.equals(p.getExType(), failDetailItem.getExType()) && StringUtils.equals(p.getExMsg(), failDetailItem.getExMsg())).findAny();
                    if (yopFailDetail.isPresent()) {
                        yopFailDetail.get().getOccurDate().add(failDetailItem.getOccurDate());
                        continue;
                    }
                    YopFailureList newYopFailDetail = new YopFailureList(failDetail.getExType(), failDetail.getExMsg());
                    newYopFailDetail.getOccurDate().add(failDetail.getOccurDate());
                    payload.getFailDetails().add(newYopFailDetail);
                } while (!reportReference.compareAndSet(current, update));
                ClientReporter.checkAndReport(reportKey, (YopHostRequestReport)reportReference.get());
            }
            catch (Exception e) {
                LOGGER.warn("Error Collect ReportEvent, value:" + this.event, e);
            }
        }
    }
}

