/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.metric.report;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.cache.YopCredentialsCache;
import com.yeepay.yop.sdk.client.YopGlobalClient;
import com.yeepay.yop.sdk.client.cmd.YopCmdExecutorRegistry;
import com.yeepay.yop.sdk.client.metric.report.YopLocalReporter;
import com.yeepay.yop.sdk.client.metric.report.YopReport;
import com.yeepay.yop.sdk.client.metric.report.YopReportException;
import com.yeepay.yop.sdk.client.metric.report.YopReporter;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.report.YopReportRequest;
import com.yeepay.yop.sdk.model.report.YopReportResponse;
import com.yeepay.yop.sdk.service.common.YopClient;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopRemoteReporter
implements YopReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopRemoteReporter.class);
    public static final YopRemoteReporter INSTANCE = new YopRemoteReporter();
    private static final YopReporter BACKUP_REPORTER = YopLocalReporter.INSTANCE;
    private static final YopClient YOP_CLIENT = YopGlobalClient.getClient();

    @Override
    public void report(YopReport report) throws YopReportException {
        this.batchReport(Lists.newArrayList(report));
    }

    private void doRemoteReport(YopRequest request, List<YopReport> reports) throws YopReportException {
        try {
            YopReportRequest reportRequest = new YopReportRequest();
            reportRequest.setReports(reports);
            request.setContent(JsonUtils.toJsonString(reportRequest));
            YopResponse response = YOP_CLIENT.request(request);
            this.handleReportResponse(response);
        }
        catch (YopClientException ex) {
            LOGGER.warn("Remote Report Fail For Client Error, exType:{}, exMsg:{}", (Object)ex.getClass().getCanonicalName(), (Object)StringUtils.defaultString(ex.getMessage()));
            BACKUP_REPORTER.batchReport(reports);
        }
        catch (Exception e) {
            throw new YopReportException("Remote Report Fail For Server Error, ex:", e);
        }
    }

    private YopRequest initReportRequest() {
        YopRequest request = new YopRequest("/rest/v1.0/yop/client/report", "POST");
        request.getRequestConfig().setSkipVerifySign(true).setNeedEncrypt(false).setReadTimeout(60000);
        this.chooseAvailableCredentials(request);
        return request;
    }

    private void handleReportResponse(YopResponse response) throws IOException {
        YopReportResponse reportResponse = new YopReportResponse();
        JsonUtils.load(response.getStringResult(), (Object)reportResponse);
        YopCmdExecutorRegistry.get(reportResponse.getCmdType()).execute(reportResponse.getCmd(), new Object[0]);
    }

    @Override
    public void batchReport(List<YopReport> reports) throws YopReportException {
        YopRequest request = this.initReportRequest();
        this.doRemoteReport(request, reports);
    }

    private void chooseAvailableCredentials(YopRequest request) {
        YopCredentials<?> credentials;
        List<String> availableApps = YopCredentialsCache.listKeys();
        if (CollectionUtils.isNotEmpty(availableApps) && null != (credentials = YopCredentialsCache.get(availableApps.get(0)))) {
            request.getRequestConfig().setAppKey(availableApps.get(0));
            request.getRequestConfig().setCredentials(credentials);
        }
    }
}

