/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.yop.sdk.YopConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class ServerRootSpace
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final URI serverRoot;
    private final URI yosServerRoot;
    private final List<URI> preferredEndPoint;
    private final List<URI> preferredYosEndPoint;
    private final URI sandboxServerRoot;

    public ServerRootSpace(URI serverRoot, URI yosServerRoot, URI sandboxServerRoot) {
        this.serverRoot = serverRoot;
        this.yosServerRoot = yosServerRoot;
        this.preferredEndPoint = YopConstants.DEFAULT_PREFERRED_SERVER_ROOT;
        this.preferredYosEndPoint = Collections.emptyList();
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public ServerRootSpace(URI serverRoot, URI yosServerRoot, List<URI> preferredEndPoint, List<URI> preferredYosEndPoint, URI sandboxServerRoot) {
        this.serverRoot = serverRoot;
        this.yosServerRoot = yosServerRoot;
        this.preferredEndPoint = CollectionUtils.isEmpty(preferredEndPoint) ? YopConstants.DEFAULT_PREFERRED_SERVER_ROOT : preferredEndPoint;
        this.preferredYosEndPoint = preferredYosEndPoint;
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public URI getServerRoot() {
        return this.serverRoot;
    }

    public URI getYosServerRoot() {
        return this.yosServerRoot;
    }

    public List<URI> getPreferredEndPoint() {
        return this.preferredEndPoint;
    }

    public List<URI> getPreferredYosEndPoint() {
        return this.preferredYosEndPoint;
    }

    public URI getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }
}

