/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.client.ClientReporter;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostStatusChangePayload;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostStatusChangeReport;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.RouteUtils;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.client.router.enums.ModeEnum;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.invoke.model.UriResource;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.sentinel.YopSph;
import com.yeepay.yop.sdk.utils.CheckUtils;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGateWayRouter
implements GateWayRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleGateWayRouter.class);
    private static final Map<ServerRootType, CopyOnWriteArrayList<URI>> ALL_SERVER = Maps.newConcurrentMap();
    private static final Map<URI, Set<ServerRootType>> ALL_SERVER_TYPES = Maps.newConcurrentMap();
    private static final Map<ServerRootType, URI> MAIN_SERVER = Maps.newConcurrentMap();
    private static final Map<ServerRootType, List<URI>> BACKUP_SERVERS = Maps.newConcurrentMap();
    private static final YopSph.BlockResourcePool BLOCK_SERVER_POOL = new YopSph.BlockResourcePool();
    private static final String SYSTEM_SDK_MODE_KEY = "yop.sdk.mode";
    private static final String SANDBOX_APP_ID_PREFIX = "sandbox_";
    private static final List<ServerRootType> MANUAL_SERVER_ROOT_TYPES = Lists.newArrayList(ServerRootType.COMMON, ServerRootType.YOS);
    private final ServerRootSpace space;
    private final Set<String> independentApiGroups;
    private final ModeEnum systemMode;

    public SimpleGateWayRouter(ServerRootSpace space) {
        this.space = space;
        this.independentApiGroups = Collections.unmodifiableSet(Sets.newHashSet("bank-encryption"));
        String systemModeConfig = System.getProperty(SYSTEM_SDK_MODE_KEY);
        this.systemMode = StringUtils.isEmpty(systemModeConfig) ? null : ModeEnum.valueOf(systemModeConfig);
        SimpleGateWayRouter.addServerRoots(space);
    }

    private static void addServerRoots(ServerRootSpace space) {
        if (CollectionUtils.isNotEmpty(space.getPreferredEndPoint())) {
            for (URI uri : space.getPreferredEndPoint()) {
                SimpleGateWayRouter.addServerRoot(uri, ServerRootType.COMMON);
            }
        }
        if (CollectionUtils.isNotEmpty(space.getPreferredYosEndPoint())) {
            for (URI uri : space.getPreferredYosEndPoint()) {
                SimpleGateWayRouter.addServerRoot(uri, ServerRootType.YOS);
            }
        }
        SimpleGateWayRouter.addServerRoot(space.getYosServerRoot(), ServerRootType.YOS);
    }

    private static boolean addServerRoot(URI serverRoot, ServerRootType serverRootType) {
        if (null != serverRoot) {
            ALL_SERVER_TYPES.computeIfAbsent(serverRoot, p -> Sets.newHashSet()).add(serverRootType);
            CopyOnWriteArrayList serverRoots = ALL_SERVER.computeIfAbsent(serverRootType, p -> Lists.newCopyOnWriteArrayList());
            return serverRoots.addIfAbsent(serverRoot);
        }
        return false;
    }

    private static void addServerRoot(URI serverRoot, List<ServerRootType> serverRootTypes) {
        if (null != serverRoot && CollectionUtils.isNotEmpty(serverRootTypes)) {
            for (ServerRootType serverRootType : serverRootTypes) {
                SimpleGateWayRouter.addServerRoot(serverRoot, serverRootType);
            }
        }
    }

    private static void monitorServerRoot() {
        EventObserverRegistry.getInstance().addStateChangeObserver("BLOCKED_SERVERS_CHANGED", (prevState, newState, rule, snapshotValue) -> {
            try {
                UriResource uriResource = UriResource.parseResourceKey(rule.getResource());
                URI serverRoot = uriResource.getResource();
                LOGGER.info("ServerRoot Block State Changed, serverRoot:{}, old:{}, new:{}, rule:{}", new Object[]{serverRoot, prevState, newState, rule});
                Set<ServerRootType> serverRootTypes = ALL_SERVER_TYPES.get(serverRoot);
                Set<String> serverTypes = CollectionUtils.isEmpty(serverRootTypes) ? Collections.emptySet() : serverRootTypes.stream().map(Enum::name).collect(Collectors.toSet());
                BLOCK_SERVER_POOL.onServerStatusChange(uriResource, prevState, newState, rule, serverTypes);
                ClientReporter.asyncReportToQueue(new YopHostStatusChangeReport(new YopHostStatusChangePayload(serverRoot.toString(), prevState.name(), newState.name(), rule.toString())));
            }
            catch (Exception e) {
                LOGGER.warn("UnexpectedError, MonitorServerRoot ex:", e);
            }
        });
    }

    private static List<String> getAllServerRoots(ServerRootType serverRootType) {
        CopyOnWriteArrayList<URI> serverRoots = ALL_SERVER.get((Object)serverRootType);
        if (CollectionUtils.isEmpty(serverRoots)) {
            return Collections.emptyList();
        }
        return serverRoots.stream().map(URI::toString).collect(Collectors.toList());
    }

    @Override
    public UriResource route(String appKey, Request<?> request, List<URI> excludeServerRoots) {
        ServerRootType serverRootType;
        if (this.isAppInSandbox(appKey)) {
            return new UriResource(this.space.getSandboxServerRoot());
        }
        YopRequestConfig requestConfig = ((BaseRequest)request.getOriginalRequestObject()).getRequestConfig();
        ServerRootType serverRootType2 = serverRootType = request.isYosRequest() ? ServerRootType.YOS : ServerRootType.COMMON;
        if (StringUtils.isNotBlank(requestConfig.getServerRoot())) {
            URI serverRoot = CheckUtils.checkServerRoot(requestConfig.getServerRoot());
            if (this.isExcludeServerRoots(serverRoot, excludeServerRoots)) {
                throw new YopClientException("RequestConfig Error, serverRoot excluded:" + serverRoot);
            }
            SimpleGateWayRouter.addServerRoot(serverRoot, MANUAL_SERVER_ROOT_TYPES);
            return new UriResource(serverRoot);
        }
        String apiGroup = request.getServiceName().toLowerCase().replace("_", "-");
        if (this.independentApiGroups.contains(apiGroup)) {
            URI independentServerRoot = this.independentServerRoot(apiGroup, request);
            if (this.isExcludeServerRoots(independentServerRoot, excludeServerRoots)) {
                throw new YopClientException("Config Error, ServerRoot excluded:" + independentServerRoot);
            }
            return new UriResource(independentServerRoot);
        }
        CopyOnWriteArrayList<URI> serverRoots = ALL_SERVER.get((Object)serverRootType);
        if (CollectionUtils.isEmpty(serverRoots)) {
            throw new YopClientException("Config Error, No ServerRoot Found, type:" + (Object)((Object)serverRootType));
        }
        URI mainServer = MAIN_SERVER.get((Object)serverRootType);
        if (null == mainServer) {
            List<URI> randomList = RouteUtils.randomList(serverRoots);
            if (this.recordMainServer(randomList.remove(0), serverRootType)) {
                BACKUP_SERVERS.put(serverRootType, randomList);
            }
            mainServer = MAIN_SERVER.get((Object)serverRootType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Main ServerRoot Set, value:{}", (Object)mainServer);
            }
        }
        if (null != mainServer && !this.isExcludeServerRoots(mainServer, excludeServerRoots)) {
            return new UriResource(mainServer);
        }
        List<URI> backupServers = BACKUP_SERVERS.get((Object)serverRootType);
        if (CollectionUtils.isNotEmpty(backupServers)) {
            for (URI backup : backupServers) {
                if (this.isExcludeServerRoots(backup, excludeServerRoots)) continue;
                return new UriResource(backup);
            }
        }
        return BLOCK_SERVER_POOL.select(serverRootType.name(), mainServer);
    }

    private boolean isExcludeServerRoots(URI serverRoot, List<URI> excludeServerRoots) {
        return null != excludeServerRoots && null != serverRoot && excludeServerRoots.contains(serverRoot);
    }

    private boolean recordMainServer(URI serverRoot, ServerRootType serverRootType) {
        return this.recordMainServer(serverRoot, serverRootType, false);
    }

    private void recordMainServer(URI serverRoot, List<ServerRootType> serverRootTypes, boolean force) {
        if (CollectionUtils.isEmpty(serverRootTypes)) {
            throw new YopClientException("Config Error, No ServerRootType Specified");
        }
        for (ServerRootType serverRootType : serverRootTypes) {
            this.recordMainServer(serverRoot, serverRootType, force);
        }
    }

    private boolean recordMainServer(URI serverRoot, ServerRootType serverRootType, boolean force) {
        if (null == serverRoot) {
            throw new YopClientException("Config Error, No ServerRoot Found, type:" + (Object)((Object)serverRootType));
        }
        URI oldMain = MAIN_SERVER.putIfAbsent(serverRootType, serverRoot);
        if (null != oldMain) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Main ServerRoot Already Set, value:{}", (Object)oldMain);
            }
            if (force) {
                MAIN_SERVER.put(serverRootType, serverRoot);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Main ServerRoot Switched, old:{}, new:{}", (Object)oldMain, (Object)serverRoot);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private URI independentServerRoot(String apiGroup, Request<?> request) {
        try {
            URI serverRoot = request.isYosRequest() ? this.space.getYosServerRoot() : this.space.getServerRoot();
            return new URI(serverRoot.getScheme(), serverRoot.getUserInfo(), this.getIndependentApiGroupHost(apiGroup, serverRoot.getHost(), request.isYosRequest()), serverRoot.getPort(), serverRoot.getPath(), serverRoot.getQuery(), serverRoot.getFragment());
        }
        catch (Exception ex) {
            throw new YopClientException("Route Request Failure, ex:", ex);
        }
    }

    private boolean isAppInSandbox(String appKey) {
        if (this.systemMode == null) {
            return StringUtils.startsWith(appKey, SANDBOX_APP_ID_PREFIX);
        }
        return this.systemMode == ModeEnum.sandbox;
    }

    private String getIndependentApiGroupHost(String apiGroup, String originHost, boolean isYosRequest) {
        if (isYosRequest) {
            return originHost;
        }
        int index = StringUtils.indexOf((CharSequence)originHost, ".");
        return StringUtils.substring(originHost, 0, index) + "-" + apiGroup + StringUtils.substring(originHost, index);
    }

    static {
        SimpleGateWayRouter.monitorServerRoot();
    }

    private static enum ServerRootType {
        COMMON,
        YOS,
        SANDBOX;

    }
}

