/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.base.security.cert;

import com.yeepay.yop.sdk.base.security.cert.X509CertSupport;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Sm2CertSupport
implements X509CertSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509Sm2CertSupport.class);

    @Override
    public X509Certificate generate(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)cf.generateCertificate(inputStream);
    }

    @Override
    public void verifyCertificate(PublicKey issuerPubKey, X509Certificate cert) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.verify(issuerPubKey, "BC");
    }

    @Override
    public String support() {
        return CertTypeEnum.SM2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(X509Certificate cert, File file) throws IOException, CertificateEncodingException {
        File certFile = file;
        JcaPEMWriter jcaPEMWriter = null;
        try {
            jcaPEMWriter = new JcaPEMWriter((Writer)new FileWriter(certFile));
            jcaPEMWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", cert.getEncoded()));
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(jcaPEMWriter);
            throw throwable;
        }
        StreamUtils.closeQuietly((Closeable)jcaPEMWriter);
    }

    static {
        SmUtils.init();
    }
}

