/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.base.security.cert.parser;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.security.cert.parser.AbstractYopPublicKeyParser;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParser;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;

public class YopSm2PublicKeyParser
extends AbstractYopPublicKeyParser
implements YopCertParser {
    @Override
    public YopPublicKey parse(YopCertConfig certConfig) {
        if (null == certConfig.getStoreType()) {
            throw new YopClientException("ConfigProblem, YopPublicKey StoreType IsNull, certConfig:" + certConfig);
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    return new YopPublicKey(SmUtils.string2PublicKey(certConfig.getValue()));
                }
                catch (Exception ex) {
                    throw new YopClientException("ConfigProblem, YopPublicKey Value Illegal, certConfig:" + certConfig, ex);
                }
            }
            case FILE_CER: {
                try {
                    return new YopPublicKey(this.getX509Cert(certConfig.getValue(), CertTypeEnum.SM2));
                }
                catch (Exception e) {
                    throw new YopClientException("ConfigProblem, YopPublicKey Value Illegal, certConfig:" + certConfig, e);
                }
            }
        }
        throw new YopClientException("ConfigProblem, YopPublicKey StoreType Illegal, certConfig:" + certConfig);
    }

    @Override
    public String parserId() {
        return StringUtils.joinWith(",", new Object[]{YopCertCategory.PUBLIC, CertTypeEnum.SM2});
    }

    static {
        SmUtils.init();
    }
}

