/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.base.utils;

import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmUtils.class);

    public static void init() {
    }

    public static PublicKey string2PublicKey(String pubKey) {
        try {
            byte[] x509Bytes = Encodes.decodeBase64(pubKey);
            X509EncodedKeySpec eks = new X509EncodedKeySpec(x509Bytes);
            KeyFactory kf = KeyFactory.getInstance("EC", "BC");
            return kf.generatePublic(eks);
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, YopPublicKey Convert Fail, value:" + pubKey, e);
        }
    }

    static {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            LOGGER.debug("BouncyCastleProvider added");
        }
        catch (Exception e) {
            LOGGER.warn("error when add BouncyCastleProvider", e);
        }
    }
}

