/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.security.cert.parser;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.security.cert.parser.AbstractYopPrivateKeyParser;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParser;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.gm.utils.Sm2Utils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;

public class YopSm2PrivateKeyParser
extends AbstractYopPrivateKeyParser
implements YopCertParser {
    @Override
    public PrivateKey parse(YopCertConfig certConfig) {
        if (null == certConfig.getStoreType()) {
            throw new YopClientException("ConfigProblem, IsvPrivateKey StoreType IsNull, certConfig:" + certConfig);
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    return Sm2Utils.string2PrivateKey(certConfig.getValue());
                }
                catch (Exception ex) {
                    throw new YopClientException("ConfigProblem, IsvPrivateKey Value Illegal, certConfig:" + certConfig, ex);
                }
            }
            case FILE_P12: {
                try {
                    return this.parsePrivateKey(certConfig.getPassword(), certConfig.getValue());
                }
                catch (Exception ex) {
                    throw new YopClientException("ConfigProblem, IsvPrivateKey Password Illegal, certConfig:" + certConfig, ex);
                }
            }
        }
        throw new YopClientException("ConfigProblem, IsvPrivateKey StoreType NotSupport, certConfig:" + certConfig);
    }

    @Override
    public String parserId() {
        return StringUtils.joinWith(",", new Object[]{YopCertCategory.PRIVATE, CertTypeEnum.SM2});
    }

    @Override
    protected KeyStore getKeyStore() throws KeyStoreException, NoSuchProviderException {
        return KeyStore.getInstance("PKCS12", "BC");
    }

    static {
        SmUtils.init();
    }
}

