/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.utils;

import com.yeepay.shade.com.google.common.base.Charsets;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class Sm4Utils {
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_GCM_NOPADDING = "SM4/GCM/NoPadding";
    public static final int DEFAULT_KEY_SIZE = 128;

    public static byte[] generateKey() {
        try {
            return Sm4Utils.generateKey(128);
        }
        catch (Exception e) {
            throw new YopClientException("UnexpectedError, Generate Sm4Key Fail, ex:", e);
        }
    }

    public static byte[] generateKey(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg2 = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg2.init(keySize, new SecureRandom());
        return kg2.generateKey().getEncoded();
    }

    public static byte[] doCMac(byte[] key, byte[] data) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec keyObj = new SecretKeySpec(key, ALGORITHM_NAME);
        return Sm4Utils.doMac("SM4-CMAC", keyObj, data);
    }

    public static byte[] doGMac(byte[] key, byte[] iv, int tagLength, byte[] data) {
        GMac mac = new GMac(new GCMBlockCipher((BlockCipher)new SM4Engine()), tagLength * 8);
        return Sm4Utils.doMac((org.bouncycastle.crypto.Mac)mac, key, iv, data);
    }

    public static byte[] doCBCMac(byte[] key, byte[] iv, byte[] data) {
        SM4Engine engine = new SM4Engine();
        CBCBlockCipherMac mac = new CBCBlockCipherMac((BlockCipher)engine, engine.getBlockSize() * 8, (BlockCipherPadding)new PKCS7Padding());
        return Sm4Utils.doMac((org.bouncycastle.crypto.Mac)mac, key, iv, data);
    }

    private static byte[] doMac(org.bouncycastle.crypto.Mac mac, byte[] key, byte[] iv, byte[] data) {
        KeyParameter cipherParameters = new KeyParameter(key);
        mac.init((CipherParameters)new ParametersWithIV((CipherParameters)cipherParameters, iv));
        mac.update(data, 0, data.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    private static byte[] doMac(String algorithmName, Key key, byte[] data) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithmName, "BC");
        mac.init(key);
        mac.update(data);
        return mac.doFinal();
    }

    public static byte[] decrypt_GCM_NoPadding(byte[] key, String associatedData, String nonce, String ciphertext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_GCM_NOPADDING, "BC");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM_NAME);
        byte[] nonceBytes = null != nonce ? Encodes.decodeBase64(nonce) : new byte[12];
        GCMParameterSpec spec = new GCMParameterSpec(128, nonceBytes);
        cipher.init(2, (Key)secretKeySpec, spec);
        if (StringUtils.isNotBlank(associatedData)) {
            cipher.updateAAD(associatedData.getBytes(Charsets.UTF_8));
        }
        return cipher.doFinal(Encodes.decodeBase64(ciphertext));
    }

    static {
        SmUtils.init();
    }
}

