/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.support.ClientConfigurationSupport;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpClientProvider;
import java.util.Map;
import java.util.ServiceLoader;

public class YopHttpClientFactory {
    private static volatile YopHttpClient defaultClient;
    private static final Map<String, YopHttpClientProvider> httpClientProviderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YopHttpClient getDefaultClient() {
        if (defaultClient != null) return defaultClient;
        Class<YopHttpClientFactory> clazz = YopHttpClientFactory.class;
        synchronized (YopHttpClientFactory.class) {
            if (defaultClient != null) return defaultClient;
            YopSdkConfigProvider yopSdkConfigProvider = YopSdkConfigProviderRegistry.getProvider();
            ClientConfiguration clientConfiguration = ClientConfigurationSupport.getClientConfiguration(yopSdkConfigProvider.getConfig());
            defaultClient = YopHttpClientFactory.getClient(clientConfiguration);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultClient;
        }
    }

    public static YopHttpClient getClient(ClientConfiguration clientConfig) {
        YopHttpClientProvider yopHttpClientProvider = httpClientProviderMap.get(clientConfig.getClientImpl());
        if (null == yopHttpClientProvider) {
            throw new YopClientException("SetUpProblem, YopHttpClientProvider NotFound, name:" + clientConfig.getClientImpl());
        }
        return yopHttpClientProvider.get(clientConfig);
    }

    static {
        httpClientProviderMap = Maps.newHashMap();
        ServiceLoader<YopHttpClientProvider> serviceLoader = ServiceLoader.load(YopHttpClientProvider.class);
        for (YopHttpClientProvider yopHttpClientProvider : serviceLoader) {
            httpClientProviderMap.put(yopHttpClientProvider.name(), yopHttpClientProvider);
        }
        if (httpClientProviderMap.isEmpty()) {
            throw new YopClientException("SetUpProblem\uff0cYopHttpClientProvider NotFound!");
        }
    }
}

