/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.shade.com.jayway.jsonpath.DocumentContext;
import com.yeepay.shade.com.jayway.jsonpath.JsonPath;
import com.yeepay.shade.com.jayway.jsonpath.Predicate;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptProtocol;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopContentDecryptAnalyzer
implements HttpResponseAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopContentDecryptAnalyzer.class);
    private static final YopContentDecryptAnalyzer INSTANCE = new YopContentDecryptAnalyzer();

    public static YopContentDecryptAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopContentDecryptAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopResponseMetadata metadata = response.getMetadata();
        if (!context.isEncryptSupported()) {
            return false;
        }
        EncryptOptions reqEncryptOptions = context.getEncryptOptions();
        YopEncryptProtocol.Inst parsedEncryptProtocol = this.parseEncryptProtocol(metadata.getYopEncrypt(), context.getYopCredentials(), reqEncryptOptions);
        if (null == parsedEncryptProtocol) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response encrypted, requestId:{}, headers:{}, params:{}", metadata.getYopRequestId(), parsedEncryptProtocol.getEncryptHeaders(), parsedEncryptProtocol.getEncryptParams());
        }
        EncryptOptions respEncryptOptions = parsedEncryptProtocol.getEncryptOptions();
        YopHttpResponse httpResponse = context.getResponse();
        this.decryptHeaders(httpResponse, parsedEncryptProtocol, context.getEncryptor(), respEncryptOptions);
        if (null != httpResponse.getContent()) {
            if (HttpUtils.isJsonResponse(metadata.getContentType())) {
                this.decryptJsonContent(httpResponse, parsedEncryptProtocol, context.getEncryptor(), respEncryptOptions);
            } else {
                this.decryptDownloadStream(httpResponse, context.getEncryptor(), respEncryptOptions);
            }
        }
        return false;
    }

    private void decryptDownloadStream(YopHttpResponse httpResponse, YopEncryptor encryptor, EncryptOptions encryptOptions) {
        httpResponse.setContent(encryptor.decrypt(httpResponse.getContent(), encryptOptions));
    }

    private void decryptJsonContent(YopHttpResponse httpResponse, YopEncryptProtocol.Inst parsedEncryptProtocol, YopEncryptor encryptor, EncryptOptions encryptOptions) {
        String content = httpResponse.readContent();
        if (null == content) {
            return;
        }
        Map yopResp = JsonUtils.fromJsonString(content, Map.class);
        Object encryptBizContent = yopResp.get("result");
        if (JsonUtils.isTotalEncrypt(parsedEncryptProtocol.getEncryptParams())) {
            httpResponse.setContent(String.format("{\"result\":%s}", encryptor.decryptFromBase64((String)encryptBizContent, encryptOptions)));
            return;
        }
        String jsonBizContent = JsonUtils.toJsonString(encryptBizContent);
        Set<String> encryptPaths = JsonUtils.resolveAllJsonPaths(jsonBizContent, parsedEncryptProtocol.getEncryptParams());
        DocumentContext valReadWriteCtx = JsonPath.parse(jsonBizContent);
        for (String path : encryptPaths) {
            try {
                String encryptVal = String.valueOf((char[])valReadWriteCtx.read(path, new Predicate[0]));
                if (!StringUtils.isNotBlank(encryptVal)) continue;
                valReadWriteCtx.set(path, encryptor.decryptFromBase64(encryptVal, encryptOptions), new Predicate[0]);
            }
            catch (Exception e) {
                LOGGER.error("error when decrypt, path:" + path + ", json:" + jsonBizContent, e);
            }
        }
        yopResp.put("result", valReadWriteCtx.json());
        String decryptedContent = JsonUtils.toJsonString(yopResp);
        LOGGER.debug("json request decrypted, source:{}, target:{}, options:{}", content, decryptedContent, encryptOptions);
        httpResponse.setContent(decryptedContent);
    }

    private void decryptHeaders(YopHttpResponse httpResponse, YopEncryptProtocol.Inst parsedEncryptProtocol, YopEncryptor encryptor, EncryptOptions encryptOptions) {
        Map<String, String> headers = httpResponse.getHeaders();
        if (CollectionUtils.isEmpty(parsedEncryptProtocol.getEncryptHeaders()) || MapUtils.isEmpty(headers)) {
            return;
        }
        for (String encryptHeader : parsedEncryptProtocol.getEncryptHeaders()) {
            if (!headers.containsKey(encryptHeader)) continue;
            headers.put(encryptHeader, encryptor.decryptFromBase64(headers.get(encryptHeader), encryptOptions));
        }
    }

    private YopEncryptProtocol.Inst parseEncryptProtocol(String encryptProtocol, YopCredentials<?> yopCredentials, EncryptOptions encryptOptions) {
        if (StringUtils.isNotBlank(encryptProtocol)) {
            return YopEncryptProtocol.fromProtocol(encryptProtocol).parse(new YopEncryptProtocol.ParseParams(encryptProtocol, yopCredentials, encryptOptions));
        }
        return null;
    }
}

