/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.exception.YopHttpException;
import com.yeepay.yop.sdk.exception.YopServiceException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopErrorResponse;
import com.yeepay.yop.sdk.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopErrorResponseAnalyzer
implements HttpResponseAnalyzer {
    private static final YopErrorResponseAnalyzer INSTANCE = new YopErrorResponseAnalyzer();
    private static final Logger LOGGER = LoggerFactory.getLogger(YopErrorResponseAnalyzer.class);

    public static YopErrorResponseAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopErrorResponseAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopHttpResponse httpResponse = context.getResponse();
        int statusCode = httpResponse.getStatusCode();
        if (statusCode / 100 == 2 && statusCode != 204) {
            return false;
        }
        String resource = context.getOriginRequest().getEndpoint() + "/" + context.getOriginRequest().getResourcePath();
        if (statusCode >= 500 && statusCode != 502) {
            YopServiceException yse = null;
            String content = httpResponse.readContent();
            if (null != content) {
                YopErrorResponse yopErrorResponse = null;
                try {
                    yopErrorResponse = JsonUtils.loadFrom(content, YopErrorResponse.class);
                }
                catch (Exception ex) {
                    LOGGER.warn("Response Illegal, YopErrorResponse ParseFail, content:" + content, ex);
                }
                if (yopErrorResponse != null && yopErrorResponse.getMessage() != null) {
                    yse = new YopServiceException(yopErrorResponse.getMessage());
                    yse.setErrorCode(yopErrorResponse.getCode());
                    yse.setSubErrorCode(yopErrorResponse.getSubCode());
                    yse.setSubMessage(yopErrorResponse.getSubMessage());
                    yse.setRequestId(yopErrorResponse.getRequestId());
                    yse.setDocUrl(yopErrorResponse.getDocUrl());
                }
            }
            if (yse == null) {
                yse = new YopServiceException(httpResponse.getStatusText());
                yse.setRequestId(response.getMetadata().getYopRequestId());
            }
            yse.setStatusCode(httpResponse.getStatusCode());
            yse.setErrorType(YopServiceException.ErrorType.Service);
            throw yse;
        }
        if (statusCode == 502 || statusCode == 404) {
            throw new YopHttpException("ResponseError, Unexpected Response, statusCode:" + statusCode + ", resource:" + resource);
        }
        YopServiceException invokeEx = new YopServiceException("ReqParam Illegal, Bad Request, statusCode:" + statusCode + ", resource:" + resource);
        invokeEx.setErrorType(YopServiceException.ErrorType.Client);
        throw invokeEx;
    }
}

