/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.yos.YosDownloadInputStream;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponseMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YosDownloadResponseAnalyzer
implements HttpResponseAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(YosDownloadResponseAnalyzer.class);
    private static final YosDownloadResponseAnalyzer INSTANCE = new YosDownloadResponseAnalyzer();

    public static YosDownloadResponseAnalyzer getInstance() {
        return INSTANCE;
    }

    private YosDownloadResponseAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        int pos;
        if (!(response instanceof YosDownloadResponse)) {
            return false;
        }
        YopHttpResponse httpResponse = context.getResponse();
        YosDownloadResponse downloadResponse = (YosDownloadResponse)response;
        YosDownloadResponseMetadata downloadMetadata = downloadResponse.getMetadata();
        downloadMetadata.setAppendOffset(httpResponse.getHeaderAsLong("x-yop-next-append-offset"));
        downloadMetadata.setCacheControl(httpResponse.getHeader("Cache-Control"));
        if (downloadMetadata.getContentRange() != null && (pos = downloadMetadata.getContentRange().lastIndexOf(47)) >= 0) {
            try {
                downloadMetadata.setInstanceLength(Long.parseLong(downloadMetadata.getContentRange().substring(pos + 1)));
            }
            catch (NumberFormatException e) {
                logger.warn("Fail to parse length from Content-Range: " + downloadMetadata.getContentRange(), e);
            }
        }
        downloadMetadata.setLastModified(httpResponse.getHeaderAsRfc822Date("Last-Modified"));
        downloadMetadata.setYopContentSha256(httpResponse.getHeader("x-yop-content-sha256"));
        downloadResponse.setResult(new YosDownloadInputStream(httpResponse));
        return true;
    }
}

