/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.exception.YopServiceException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.yos.BaseYosUploadResponse;
import com.yeepay.yop.sdk.model.yos.YosUploadResponseMetadata;
import com.yeepay.yop.sdk.utils.checksum.CRC64Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CheckedInputStream;

public class YosUploadIntegrityCheckAnalyzer
implements HttpResponseAnalyzer {
    private static final YosUploadIntegrityCheckAnalyzer INSTANCE = new YosUploadIntegrityCheckAnalyzer();

    public static YosUploadIntegrityCheckAnalyzer getInstance() {
        return INSTANCE;
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        if (!(response instanceof BaseYosUploadResponse)) {
            return false;
        }
        YosUploadResponseMetadata uploadResponseMetadata = ((BaseYosUploadResponse)response).getMetadata();
        if (uploadResponseMetadata.getCrc64ECMA() == null) {
            return false;
        }
        String requestCrc64 = this.getRequestCrc64(context.getOriginRequest());
        if (requestCrc64 == null) {
            return false;
        }
        if (StringUtils.equals(uploadResponseMetadata.getCrc64ECMA(), requestCrc64)) {
            return false;
        }
        YopServiceException ex = new YopServiceException("\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        ex.setErrorCode("40044");
        ex.setSubErrorCode("isv.scene.filestore.put.crc-failed");
        ex.setSubMessage("\u6587\u4ef6\u4e0a\u4f20crc\u6821\u9a8c\u5931\u8d25");
        throw ex;
    }

    private String getRequestCrc64(Request originRequest) {
        Map<String, List<MultiPartFile>> files = originRequest.getMultiPartFiles();
        if (MapUtils.isEmpty(files)) {
            return null;
        }
        TreeMap<String, List<MultiPartFile>> sortedFiles = Maps.newTreeMap();
        sortedFiles.putAll(files);
        ArrayList<CheckedInputStream> inputStreams = Lists.newArrayListWithExpectedSize(sortedFiles.size());
        for (List items : sortedFiles.values()) {
            for (MultiPartFile item : items) {
                inputStreams.add(item.getInputStream());
            }
        }
        return CRC64Utils.getCRC64(inputStreams);
    }
}

