/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.impl.apache;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.org.apache.http.conn.HttpClientConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleConnectionReaper
extends Thread {
    private static final int PERIOD_IN_MILLIS = 20000;
    private static final List<HttpClientConnectionManager> connectionManagers = Lists.newArrayList();
    private static IdleConnectionReaper instance = new IdleConnectionReaper();
    private static final Logger logger;

    private IdleConnectionReaper() {
        super("java-sdk-http-connection-reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            return false;
        }
        return connectionManagers.add(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            return false;
        }
        return connectionManagers.remove(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block6: while (!this.isInterrupted()) {
            try {
                Thread.sleep(20000L);
                ArrayList<HttpClientConnectionManager> connectionManagers = null;
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.yeepay.yop.sdk.http.impl.apache.IdleConnectionReaper.class
                connectionManagers = Lists.newArrayList(IdleConnectionReaper.connectionManagers);
                // MONITOREXIT : object
                object = connectionManagers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block6;
                    HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                    try {
                        connectionManager.closeExpiredConnections();
                        connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Throwable t) {
                        logger.warn("Unable to close idle connections", t);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Reaper thread: ", t);
            }
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    static {
        instance.start();
        logger = LoggerFactory.getLogger(IdleConnectionReaper.class);
    }
}

