/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.impl.apache;

import com.yeepay.shade.org.apache.http.Header;
import com.yeepay.shade.org.apache.http.HttpException;
import com.yeepay.shade.org.apache.http.HttpInetConnection;
import com.yeepay.shade.org.apache.http.HttpResponse;
import com.yeepay.shade.org.apache.http.HttpResponseInterceptor;
import com.yeepay.shade.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopServerResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopServerResponseInterceptor.class);
    public static final YopServerResponseInterceptor INSTANCE = new YopServerResponseInterceptor();

    private YopServerResponseInterceptor() {
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Header alreadyUsed = response.getFirstHeader("x-yop-server-ip");
            if (null == alreadyUsed) {
                response.addHeader("x-yop-server-ip", ((HttpInetConnection)context.getAttribute("http.connection")).getRemoteAddress().getHostAddress());
            }
        }
        catch (Exception e) {
            LOGGER.error("error when get yop server info, ex:", e);
        }
    }
}

