/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.auth.signer.process;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.inter.utils.RSA;
import com.yeepay.yop.sdk.security.DigestAlgEnum;

public class YopRsaSignProcessor
implements YopSignProcessor {
    private static final DigestAlgEnum DIGEST_ALG = DigestAlgEnum.SHA256;

    @Override
    public String doSign(String content, CredentialsItem credentialsItem, SignOptions options) {
        PKICredentialsItem pkiCredentialsItem = (PKICredentialsItem)credentialsItem;
        return RSA.sign(content, pkiCredentialsItem.getPrivateKey(), DIGEST_ALG);
    }

    @Override
    public boolean doVerify(String content, String signature, CredentialsItem credentialsItem, SignOptions options) {
        PKICredentialsItem pkiCredentialsItem = (PKICredentialsItem)credentialsItem;
        return RSA.verifySign(content, signature, pkiCredentialsItem.getPublicKey(), DIGEST_ALG);
    }

    @Override
    public boolean isSupport(CredentialsItem credentialsItem) {
        return credentialsItem instanceof PKICredentialsItem;
    }

    @Override
    public String name() {
        return "RSA2048";
    }

    @Override
    public String getDigestAlg() {
        return DigestAlgEnum.SHA256.name();
    }
}

