/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.security.cert;

import com.yeepay.yop.sdk.base.security.cert.X509CertSupport;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509RsaCertSupport
implements X509CertSupport {
    @Override
    public X509Certificate generate(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(inputStream);
    }

    @Override
    public void verifyCertificate(PublicKey issuerPubKey, X509Certificate cert) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        cert.verify(issuerPubKey);
    }

    @Override
    public String support() {
        return CertTypeEnum.RSA2048.getValue();
    }

    @Override
    public void writeToFile(X509Certificate cert, File file) throws IOException, CertificateEncodingException {
    }
}

