/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.security.digest;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.digest.YopDigester;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopShaDigester
implements YopDigester {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopShaDigester.class);
    private final ThreadLocal<Map<String, MessageDigest>> MESSAGE_DIGEST = ThreadLocal.withInitial(YopShaDigester::initMdInstance);

    @Override
    public List<String> supportedAlgs() {
        return Lists.newArrayList(DigestAlgEnum.SHA256.name());
    }

    @Override
    public byte[] digest(InputStream input, String alg) {
        try {
            MessageDigest md = this.getMessageDigestInstance(alg);
            DigestInputStream digestInputStream = new DigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Digest Fail, alg:" + alg + ", ex:", e);
        }
    }

    protected static Map<String, MessageDigest> initMdInstance() {
        try {
            HashMap<String, MessageDigest> algMap = Maps.newHashMap();
            algMap.put("SHA256", MessageDigest.getInstance("SHA-256"));
            return algMap;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get Digest Function, will fail when use YopRSASigner for sign, ex", e);
            return Collections.emptyMap();
        }
    }

    private MessageDigest getMessageDigestInstance(String digestAlg) {
        MessageDigest messageDigest = this.MESSAGE_DIGEST.get().get(digestAlg);
        messageDigest.reset();
        return messageDigest;
    }
}

