/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.security.encrypt;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorAdaptor;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class YopAesEncryptor
extends YopEncryptorAdaptor {
    private static final ThreadLocal<Map<String, Cipher>> cipherThreadLocal = new ThreadLocal<Map<String, Cipher>>(){

        @Override
        protected Map<String, Cipher> initialValue() {
            HashMap<String, Cipher> map = Maps.newHashMap();
            try {
                map.put("AES/ECB/PKCS5Padding", Cipher.getInstance("AES/ECB/PKCS5Padding"));
                map.put("AES", Cipher.getInstance("AES"));
            }
            catch (Exception e) {
                throw new YopClientException("SystemError, InitCipher Fail, ex:", e);
            }
            return map;
        }
    };

    @Override
    public List<String> supportedAlgs() {
        return Lists.newArrayList("AES", "AES/ECB/PKCS5Padding");
    }

    @Override
    public EncryptOptions doInitEncryptOptions(String encryptAlg) throws Exception {
        return new EncryptOptions(new YopSymmetricCredentials(Encodes.encodeUrlSafeBase64(this.generateRandomKey())), "RSA", encryptAlg, null, null);
    }

    private byte[] generateRandomKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        return generator.generateKey().getEncoded();
    }

    @Override
    public byte[] encrypt(byte[] plain, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(1, options);
            return initializedCipher.doFinal(plain);
        }
        catch (Throwable t) {
            throw new YopClientException("SystemError, Encrypt Fail, options:" + options + ", ex:", t);
        }
    }

    @Override
    public InputStream encrypt(InputStream plain, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("SystemError, Encrypt Chunked NotSupport, options:" + options);
        }
        return new CipherInputStream(plain, this.getInitializedCipher(1, options, false));
    }

    @Override
    public byte[] decrypt(byte[] cipher, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(2, options);
            return initializedCipher.doFinal(cipher);
        }
        catch (Throwable t) {
            throw new YopClientException("SystemError, Decrypt Fail, options:" + options + ", ex:", t);
        }
    }

    @Override
    public InputStream decrypt(InputStream cipher, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("SystemError, Decrypt Chunked NotSupport, options:" + options);
        }
        return new CipherInputStream(cipher, this.getInitializedCipher(2, options, false));
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions) {
        return this.getInitializedCipher(mode, encryptOptions, true);
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions, boolean shareMode) {
        try {
            byte[] key = Encodes.decodeBase64(((YopSymmetricCredentials)encryptOptions.getCredentials()).getCredential());
            Cipher cipher = shareMode ? cipherThreadLocal.get().get(encryptOptions.getAlg()) : Cipher.getInstance(encryptOptions.getAlg());
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(mode, secretKey);
            return cipher;
        }
        catch (Throwable throwable) {
            throw new YopClientException("error happened when initialize cipher", throwable);
        }
    }
}

