/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.shade.org.apache.commons.lang3.tuple.ImmutablePair;
import com.yeepay.shade.org.apache.commons.lang3.tuple.Pair;
import com.yeepay.yop.sdk.internal.MarkableFileInputStream;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.checksum.CRC64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.zip.CheckedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartFile
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPartFile.class);
    private static final long serialVersionUID = -1L;
    private static final int EXT_READ_BUFFER_SIZE = 65536;
    private final CheckedInputStream inputStream;
    private final String fileName;

    public MultiPartFile(File file) throws IOException {
        this(new FileInputStream(file));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("filename parsed, origin:{}, current:{}", (Object)file.getName(), (Object)this.fileName);
        }
    }

    public MultiPartFile(InputStream in) throws IOException {
        Pair<String, CheckedInputStream> inputStreamPair = in instanceof FileInputStream ? MultiPartFile.getCheckedInputStreamPair((FileInputStream)in) : MultiPartFile.getCheckedInputStreamPair(in);
        this.fileName = inputStreamPair.getLeft();
        this.inputStream = inputStreamPair.getRight();
    }

    public MultiPartFile(InputStream in, String originFileName) throws IOException {
        this.fileName = originFileName;
        this.inputStream = MultiPartFile.getCheckedInputStream(in);
    }

    public CheckedInputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(FileInputStream fileInputStream) throws IOException {
        MarkableFileInputStream in = new MarkableFileInputStream(fileInputStream);
        in.mark(0);
        String fileName = FileUtils.getFileName(in);
        in.reset();
        return new ImmutablePair<String, CheckedInputStream>(fileName, MultiPartFile.getCheckedInputStream(in));
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(InputStream inputStream) throws IOException {
        byte[] extReadBuffer = new byte[65536];
        int totalRead = 0;
        int lastRead = inputStream.read(extReadBuffer);
        while (lastRead != -1 && (totalRead += lastRead) != 65536) {
            lastRead = inputStream.read(extReadBuffer, totalRead, 65536 - totalRead);
        }
        ByteArrayInputStream extReadIn = new ByteArrayInputStream(extReadBuffer, 0, totalRead);
        String fileName = FileUtils.getFileName(extReadIn);
        extReadIn.reset();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(extReadIn, inputStream);
        return new ImmutablePair<String, CheckedInputStream>(fileName, MultiPartFile.getCheckedInputStream(sequenceInputStream));
    }

    private static CheckedInputStream getCheckedInputStream(InputStream inputStream) throws IOException {
        return new CheckedInputStream(inputStream, new CRC64());
    }
}

