/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.com.jayway.jsonpath.DocumentContext;
import com.yeepay.shade.com.jayway.jsonpath.JsonPath;
import com.yeepay.shade.com.jayway.jsonpath.PathNotFoundException;
import com.yeepay.shade.com.jayway.jsonpath.Predicate;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.io.IOUtils;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptProtocol;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestEncryptor.class);

    public static void encrypt(Request<? extends BaseRequest> request, YopEncryptor encryptor, EncryptOptions encryptOptions) throws UnsupportedEncodingException {
        YopRequestConfig requestConfig = request.getOriginalRequestObject().getRequestConfig();
        if (BooleanUtils.isFalse(requestConfig.getNeedEncrypt())) {
            return;
        }
        Set<String> encryptHeaders = Collections.emptySet();
        Set<String> encryptParams = Collections.emptySet();
        if (BooleanUtils.isTrue(requestConfig.getNeedEncrypt())) {
            encryptHeaders = RequestEncryptor.encryptHeaders(encryptor, requestConfig.getEncryptHeaders(), request, encryptOptions);
            encryptParams = RequestEncryptor.encryptParams(encryptor, requestConfig.getEncryptParams(), request, requestConfig, encryptOptions);
        }
        if (CollectionUtils.isEmpty(encryptHeaders) && CollectionUtils.isEmpty(encryptParams)) {
            return;
        }
        RequestEncryptor.buildEncryptHeader(request, encryptHeaders, encryptParams, encryptOptions);
    }

    public static String buildEncryptHeader(Request<? extends BaseRequest> request, Set<String> encryptHeaders, Set<String> encryptParams, EncryptOptions encryptOptions) throws UnsupportedEncodingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("request encrypted, requestId:{}, headers:{}, params:{}", request.getRequestId(), encryptHeaders, encryptParams);
        }
        String encryptHeader = YopEncryptProtocol.YOP_ENCRYPT_PROTOCOL_V1_REQ.getProtocolPrefix() + "/" + RequestEncryptor.getPlatformCertSerialNo(encryptOptions) + "/" + StringUtils.replace(encryptOptions.getAlg(), "/", "_") + "/" + encryptOptions.getEncryptedCredentials() + "/" + RequestEncryptor.getIvAAD(encryptOptions) + "/" + (Object)((Object)encryptOptions.getBigParamEncryptMode()) + "/" + StringUtils.join(encryptHeaders, ";") + "/" + Encodes.encodeUrlSafeBase64(StringUtils.join(encryptParams, ";").getBytes("UTF-8"));
        LOGGER.debug("encryptHeader:{}", (Object)encryptHeader);
        request.addHeader("x-yop-encrypt", encryptHeader);
        return encryptHeader;
    }

    private static String getPlatformCertSerialNo(EncryptOptions encryptOptions) {
        String platformSerialNo = (String)encryptOptions.getEnhancerInfo().get("YOP_PLATFORM_CERT_SERIAL_NO");
        if (StringUtils.isBlank(platformSerialNo) || StringUtils.equalsIgnoreCase(platformSerialNo, "null")) {
            platformSerialNo = "";
        }
        return platformSerialNo;
    }

    private static String getIvAAD(EncryptOptions encryptOptions) {
        String iv = encryptOptions.getIv();
        String aad = encryptOptions.getAad();
        if (StringUtils.isBlank(iv) && StringUtils.isBlank(aad)) {
            return "";
        }
        if (StringUtils.isBlank(iv)) {
            iv = "";
        }
        if (StringUtils.isBlank(aad)) {
            aad = "";
        }
        return iv + ";" + aad;
    }

    private static Set<String> encryptHeaders(YopEncryptor encryptor, Set<String> encryptHeaders, Request<? extends BaseRequest> request, EncryptOptions encryptOptions) {
        if (CollectionUtils.isEmpty(encryptHeaders)) {
            return encryptHeaders;
        }
        HashSet<String> finalEncryptHeaders = Sets.newHashSetWithExpectedSize(encryptHeaders.size());
        Map<String, String> headers = request.getHeaders();
        headers.forEach((k, v) -> {
            if (encryptHeaders.contains(k) && StringUtils.isNotBlank(v)) {
                headers.put((String)k, encryptor.encryptToBase64((String)v, encryptOptions));
                finalEncryptHeaders.add((String)k);
            }
        });
        return finalEncryptHeaders;
    }

    private static Set<String> encryptParams(YopEncryptor encryptor, Set<String> encryptParams, Request<? extends BaseRequest> request, YopRequestConfig requestConfig, EncryptOptions encryptOptions) {
        boolean totalEncrypt = BooleanUtils.isTrue(requestConfig.getTotalEncrypt());
        if (!totalEncrypt && CollectionUtils.isEmpty(encryptParams) && null == request.getContent()) {
            return encryptParams;
        }
        HashSet<String> finalEncryptParams = Sets.newHashSetWithExpectedSize(encryptParams.size());
        Map<String, List<String>> parameters = request.getParameters();
        RequestEncryptor.encryptSimpleParams(encryptor, finalEncryptParams, encryptParams, parameters, encryptOptions, totalEncrypt);
        Map<String, List<MultiPartFile>> multiPartFiles = request.getMultiPartFiles();
        RequestEncryptor.encryptMultiPartParams(encryptor, finalEncryptParams, encryptParams, multiPartFiles, encryptOptions, totalEncrypt);
        RequestEncryptor.encryptContent(encryptor, finalEncryptParams, request, requestConfig, encryptOptions);
        LOGGER.debug("encryptParams finished, totalEncrypt:{}, params:{}", (Object)totalEncrypt, (Object)finalEncryptParams);
        return totalEncrypt ? YopConstants.TOTAL_ENCRYPT_PARAMS : finalEncryptParams;
    }

    private static void encryptContent(YopEncryptor encryptor, Set<String> finalEncryptParams, Request<? extends BaseRequest> request, YopRequestConfig requestConfig, EncryptOptions encryptOptions) {
        if (null == request.getContent()) {
            return;
        }
        if (HttpUtils.isJsonContentType(request)) {
            byte[] jsonBytes = RequestEncryptor.encryptJsonParams(encryptor, finalEncryptParams, requestConfig, request.getContent(), encryptOptions);
            RestartableInputStream restartableInputStream = RestartableInputStream.wrap(jsonBytes);
            request.setContent(restartableInputStream);
            request.addHeader("Content-Length", String.valueOf(jsonBytes.length));
        } else if (YopContentType.OCTET_STREAM.equals((Object)request.getContentType())) {
            request.setContent(encryptor.encrypt(request.getContent(), encryptOptions));
            finalEncryptParams.add("$");
        } else {
            throw new YopClientException("body content is not supported, contentType:" + (Object)((Object)request.getContentType()));
        }
    }

    private static byte[] encryptJsonParams(YopEncryptor encryptor, Set<String> finalEncryptParams, YopRequestConfig requestConfig, InputStream content, EncryptOptions encryptOptions) {
        try {
            String encryptedJson;
            String originJson = IOUtils.toString(content, "UTF-8");
            Set<String> encryptPaths = null;
            boolean totalEncrypt = true;
            if (BooleanUtils.isFalse(requestConfig.getTotalEncrypt())) {
                encryptPaths = JsonUtils.resolveAllJsonPaths(originJson, requestConfig.getEncryptParams());
                totalEncrypt = JsonUtils.isTotalEncrypt(encryptPaths);
            }
            if (!totalEncrypt) {
                DocumentContext valReadWriteCtx = JsonPath.parse(originJson);
                for (String encryptPath : encryptPaths) {
                    try {
                        String plainVal = JsonUtils.toJsonString(valReadWriteCtx.read(encryptPath, new Predicate[0]));
                        if (!StringUtils.isNotBlank(plainVal)) continue;
                        String encrypted = encryptor.encryptToBase64(plainVal, encryptOptions);
                        valReadWriteCtx.set(encryptPath, encrypted, new Predicate[0]);
                        finalEncryptParams.add(encryptPath);
                        LOGGER.debug("json request encrypted partly, path:{}, source:{}, target:{}, options:{}", encryptPath, plainVal, encrypted, encryptOptions);
                    }
                    catch (PathNotFoundException pathNotFoundException) {}
                }
                encryptedJson = valReadWriteCtx.jsonString();
            } else {
                finalEncryptParams.add("$");
                encryptedJson = JsonUtils.toJsonString(encryptor.encryptToBase64(originJson, encryptOptions));
            }
            LOGGER.debug("json request encrypted, source:{}, target:{}, options:{}", originJson, encryptedJson, encryptOptions);
            return encryptedJson.getBytes("UTF-8");
        }
        catch (IOException e) {
            throw new YopClientException("error happened when encrypt json", e);
        }
    }

    private static void encryptMultiPartParams(YopEncryptor encryptor, Set<String> finalEncryptParams, Set<String> encryptParams, Map<String, List<MultiPartFile>> multiPartFiles, EncryptOptions encryptOptions, boolean totalEncrypt) {
        multiPartFiles.forEach((name, list) -> {
            if (CollectionUtils.isNotEmpty(list) && (totalEncrypt || encryptParams.contains(name))) {
                ArrayList<MultiPartFile> encryptedValues = Lists.newArrayListWithExpectedSize(list.size());
                for (MultiPartFile value : list) {
                    try {
                        encryptedValues.add(new MultiPartFile(encryptor.encrypt(value.getInputStream(), encryptOptions), value.getFileName()));
                    }
                    catch (IOException e) {
                        throw new YopClientException("error happened when encrypt MultiPartFile", e);
                    }
                }
                multiPartFiles.put((String)name, (List<MultiPartFile>)encryptedValues);
                finalEncryptParams.add((String)name);
            }
        });
    }

    private static void encryptSimpleParams(YopEncryptor encryptor, Set<String> finalEncryptParams, Set<String> encryptParams, Map<String, List<String>> parameters, EncryptOptions encryptOptions, boolean totalEncrypt) {
        parameters.forEach((name, list) -> {
            if (CollectionUtils.isNotEmpty(list) && (totalEncrypt || encryptParams.contains(name))) {
                ArrayList<String> encryptedValues = Lists.newArrayListWithExpectedSize(list.size());
                for (String value : list) {
                    encryptedValues.add(encryptor.encryptToBase64(value, encryptOptions));
                }
                parameters.put((String)name, (List<String>)encryptedValues);
                finalEncryptParams.add((String)name);
            }
        });
    }
}

