/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.shade.com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RestartableResettableInputStream
extends RestartableInputStream {
    private final InputStream input;

    public RestartableResettableInputStream(InputStream input) {
        Preconditions.checkNotNull(input, "input should not be null.");
        Preconditions.checkArgument(input.markSupported(), "input does not support mark.");
        this.input = input;
    }

    @Override
    public void restart() {
        try {
            this.input.reset();
        }
        catch (IOException e) {
            throw new YopClientException("Fail to reset the underlying input stream.", e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

