/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.invoke;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopUnknownException;
import com.yeepay.yop.sdk.invoke.Invoker;
import com.yeepay.yop.sdk.invoke.Router;
import com.yeepay.yop.sdk.invoke.UriRouteInvoker;
import com.yeepay.yop.sdk.invoke.model.AnalyzedException;
import com.yeepay.yop.sdk.invoke.model.RetryContext;
import com.yeepay.yop.sdk.invoke.model.RetryPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRouteInvokerWrapper<Input, Output, Context extends RetryContext, Policy extends RetryPolicy, Exception extends AnalyzedException>
implements Invoker<Input, Output, Context, Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriRouteInvokerWrapper.class);
    private UriRouteInvoker<Input, Output, Context, Exception> invoker;
    private RetryPolicy retryPolicy;
    private Router<URI, Input, Context> uriRouter;

    public UriRouteInvokerWrapper(UriRouteInvoker<Input, Output, Context, Exception> invoker, RetryPolicy retryPolicy, Router<URI, Input, Context> uriRouter) {
        this.invoker = invoker;
        this.retryPolicy = retryPolicy;
        this.uriRouter = uriRouter;
    }

    @Override
    public Output invoke() {
        long start = System.currentTimeMillis();
        ArrayList<URI> excludeServerRoots = Lists.newArrayList();
        URI lastServerRoot = this.uriRouter.route(this.getInput(), this.getContext(), excludeServerRoots);
        while (!excludeServerRoots.contains(lastServerRoot)) {
            try {
                this.invoker.setUri(lastServerRoot);
                Object result = this.invoker.invoke();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Success ServerRoot, {}, elapsed:{}, retryCount:{}", this.invoker.getUri(), System.currentTimeMillis() - start, this.getContext().retryCount());
                }
                return result;
            }
            catch (Throwable throwable) {
                if (throwable instanceof YopClientException) {
                    throw throwable;
                }
                Object analyzedEx = this.invoker.getLastException();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Fail ServerRoot, {}, exDetail:{}, elapsed:{}", this.invoker.getUri(), ((AnalyzedException)analyzedEx).getExDetail(), System.currentTimeMillis() - start);
                }
                if (((AnalyzedException)analyzedEx).isNeedRetry() && null != this.retryPolicy && this.retryPolicy.allowRetry(this.invoker, throwable)) {
                    excludeServerRoots.add(lastServerRoot);
                    this.getContext().markRetried(1);
                    lastServerRoot = this.uriRouter.route(this.getInput(), this.getContext(), excludeServerRoots);
                    continue;
                }
                if (((AnalyzedException)analyzedEx).isNeedDegrade()) {
                    this.handleUnExpectedError(throwable);
                }
                throw new YopClientException("Client Error, ex:", throwable);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("All ServerRoots Unavailable, Last Try, tried:{}, last:{}", (Object)excludeServerRoots, (Object)lastServerRoot);
        }
        this.invoker.setUri(lastServerRoot);
        this.invoker.disableCircuitBreaker();
        return this.invoker.invoke();
    }

    private void handleUnExpectedError(Throwable ex) {
        if (ex instanceof YopUnknownException) {
            throw (YopUnknownException)ex;
        }
        throw new YopUnknownException("UnExpected Error, ", ex);
    }

    @Override
    public Input getInput() {
        return this.invoker.getInput();
    }

    @Override
    public void setInput(Input input) {
        this.invoker.setInput(input);
    }

    @Override
    public void setContext(Context context) {
        this.invoker.setContext(context);
    }

    @Override
    public Context getContext() {
        return (Context)((RetryContext)this.invoker.getContext());
    }

    @Override
    public List<Exception> getExceptions() {
        return this.invoker.getExceptions();
    }

    @Override
    public void addException(Exception exception) {
        this.invoker.addException(exception);
    }

    @Override
    public Exception getLastException() {
        return this.invoker.getLastException();
    }
}

