/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.model;

import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public abstract class BaseRequest
implements Serializable,
Cloneable {
    private YopRequestConfig requestConfig = YopRequestConfig.Builder.builder().build();
    private final Map<String, String> headers = Maps.newHashMap();

    public BaseRequest() {
    }

    public BaseRequest(YopRequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @JsonIgnore
    public YopRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public BaseRequest addHeader(String name, String value) {
        this.validateParameter(name, value);
        this.headers.put(StringUtils.lowerCase(name), value);
        return this;
    }

    public BaseRequest addEncryptHeader(String name, String value) {
        this.addHeader(name, value);
        this.requestConfig.addEncryptHeader(name);
        return this;
    }

    public void setSubMerchantNo(String value) {
        this.addHeader("x-yop-sub-customer-id", value);
    }

    public void setEncryptSubMerchantNo(String value) {
        this.setSubMerchantNo(value);
        this.requestConfig.addEncryptHeader("x-yop-sub-customer-id");
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public abstract String getOperationId();

    protected void validateParameter(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            throw new YopClientException("ReqParam Illegal, ParamName IsEmpty, name:" + name + ",value:" + value);
        }
        if (value == null) {
            throw new YopClientException("ReqParam Illegal, ParamValue IsNull, name:" + name);
        }
        if (value instanceof File && !((File)value).exists()) {
            throw new YopClientException("ReqParam Illegal. FileParam NotExist, name:" + name + ", value:" + value);
        }
    }
}

