/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.model;

import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import java.util.Collections;
import java.util.Set;

public class YopRequestConfig {
    private String appKey;
    private String securityReq;
    private YopCredentials<?> credentials;
    private int readTimeout;
    private int connectTimeout;
    private Boolean needEncrypt;
    private Boolean totalEncrypt;
    private String encryptAlg = "SM4/CBC/PKCS5Padding";
    private final Set<String> encryptHeaders = Sets.newHashSet();
    private final Set<String> encryptParams = Sets.newHashSet();
    private Boolean skipVerifySign;
    private Integer signExpirationInSeconds;
    private String serverRoot;
    private Boolean enableCircuitBreaker = true;

    public String getAppKey() {
        return this.appKey;
    }

    public YopRequestConfig setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getSecurityReq() {
        return this.securityReq;
    }

    public YopRequestConfig setSecurityReq(String securityReq) {
        this.securityReq = securityReq;
        return this;
    }

    public YopCredentials<?> getCredentials() {
        return this.credentials;
    }

    public YopRequestConfig setCredentials(YopCredentials<?> credentials) {
        this.credentials = credentials;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public YopRequestConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public YopRequestConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Boolean getNeedEncrypt() {
        return this.needEncrypt;
    }

    public YopRequestConfig setNeedEncrypt(Boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
        return this;
    }

    public Boolean getTotalEncrypt() {
        return this.totalEncrypt;
    }

    public YopRequestConfig setTotalEncrypt(Boolean totalEncrypt) {
        if (null != totalEncrypt) {
            this.totalEncrypt = totalEncrypt;
            if (totalEncrypt.booleanValue() && !BooleanUtils.isFalse(this.needEncrypt)) {
                this.needEncrypt = true;
            }
        }
        return this;
    }

    public String getEncryptAlg() {
        return this.encryptAlg;
    }

    public YopRequestConfig setEncryptAlg(String encryptAlg) {
        if (StringUtils.isNotBlank(encryptAlg)) {
            this.encryptAlg = encryptAlg;
        }
        return this;
    }

    public Set<String> getEncryptHeaders() {
        return Collections.unmodifiableSet(this.encryptHeaders);
    }

    public Set<String> getEncryptParams() {
        return Collections.unmodifiableSet(this.encryptParams);
    }

    public Boolean getSkipVerifySign() {
        return this.skipVerifySign;
    }

    public YopRequestConfig setSkipVerifySign(Boolean skipVerifySign) {
        this.skipVerifySign = skipVerifySign;
        return this;
    }

    public YopRequestConfig addEncryptParam(String name) {
        this.encryptParams.add(name);
        if (!BooleanUtils.isFalse(this.needEncrypt)) {
            this.needEncrypt = true;
        }
        return this;
    }

    public YopRequestConfig addEncryptParams(Set<String> params) {
        this.encryptParams.addAll(params);
        if (!BooleanUtils.isFalse(this.needEncrypt)) {
            this.needEncrypt = true;
        }
        return this;
    }

    public YopRequestConfig addEncryptHeader(String headerName) {
        this.encryptHeaders.add(StringUtils.lowerCase(headerName));
        if (!BooleanUtils.isFalse(this.needEncrypt)) {
            this.needEncrypt = true;
        }
        return this;
    }

    public Integer getSignExpirationInSeconds() {
        return this.signExpirationInSeconds;
    }

    public YopRequestConfig setSignExpirationInSeconds(Integer signExpirationInSeconds) {
        this.signExpirationInSeconds = signExpirationInSeconds;
        return this;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public YopRequestConfig setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
        return this;
    }

    public Boolean getEnableCircuitBreaker() {
        return this.enableCircuitBreaker;
    }

    public YopRequestConfig setEnableCircuitBreaker(Boolean enableCircuitBreaker) {
        this.enableCircuitBreaker = enableCircuitBreaker;
        return this;
    }

    public static final class Builder {
        private String appKey;
        private String securityReq;
        private YopCredentials<?> credentials;
        private int readTimeout;
        private int connectTimeout;
        private Boolean needEncrypt;
        private Boolean totalEncrypt;
        private String encryptAlg;
        private Boolean skipVerifySign;
        private int signExpirationInSeconds;
        private String serverRoot;
        private Boolean enableCircuitBreaker = true;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder withSecurityReq(String securityReq) {
            this.securityReq = securityReq;
            return this;
        }

        public Builder withCredentials(YopCredentials<?> credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder withRequestTimeout(Integer requestTimeout) {
            this.readTimeout = requestTimeout;
            return this;
        }

        public Builder withConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withNeedEncrypt(Boolean needEncrypt) {
            this.needEncrypt = needEncrypt;
            return this;
        }

        public Builder withTotalEncrypt(Boolean totalEncrypt) {
            this.totalEncrypt = totalEncrypt;
            return this;
        }

        public Builder withEncryptAlg(String encryptAlg) {
            this.encryptAlg = encryptAlg;
            return this;
        }

        public Builder withSkipVerifySign(Boolean skipVerifySign) {
            this.skipVerifySign = skipVerifySign;
            return this;
        }

        public Builder withSignExpirationInSeconds(int signExpirationInSeconds) {
            this.signExpirationInSeconds = signExpirationInSeconds;
            return this;
        }

        public Builder withServerRoot(String serverRoot) {
            this.serverRoot = serverRoot;
            return this;
        }

        public Builder withEnableCircuitBreaker(Boolean enableCircuitBreaker) {
            this.enableCircuitBreaker = enableCircuitBreaker;
            return this;
        }

        public YopRequestConfig build() {
            return new YopRequestConfig().setAppKey(this.appKey).setSecurityReq(this.securityReq).setCredentials(this.credentials).setReadTimeout(this.readTimeout).setConnectTimeout(this.connectTimeout).setNeedEncrypt(this.needEncrypt).setTotalEncrypt(this.totalEncrypt).setEncryptAlg(this.encryptAlg).setSkipVerifySign(this.skipVerifySign).setSignExpirationInSeconds(this.signExpirationInSeconds).setServerRoot(this.serverRoot).setEnableCircuitBreaker(this.enableCircuitBreaker);
        }
    }
}

