/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security.encrypt;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.lang3.builder.ToStringBuilder;
import com.yeepay.shade.org.apache.commons.lang3.builder.ToStringStyle;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import java.util.Collections;
import java.util.Map;

public class EncryptOptions {
    private Object credentials;
    private String encryptedCredentials;
    private String credentialsAlg;
    private String alg;
    private String iv;
    private String aad;
    private BigParamEncryptMode bigParamEncryptMode = BigParamEncryptMode.stream;
    private Map<String, Object> enhancerInfo = Maps.newHashMap();

    public EncryptOptions() {
    }

    public EncryptOptions(Object credentials) {
        this(credentials, BigParamEncryptMode.stream);
    }

    public EncryptOptions(Object credentials, String alg) {
        this.credentials = credentials;
        this.alg = alg;
    }

    public EncryptOptions(Object credentials, BigParamEncryptMode bigParamEncryptMode) {
        this.credentials = credentials;
        this.bigParamEncryptMode = bigParamEncryptMode;
    }

    public EncryptOptions(Object credentials, String alg, String iv, String aad) {
        this(credentials);
        this.alg = alg;
        this.iv = iv;
        this.aad = aad;
    }

    public EncryptOptions(Object credentials, String credentialsAlg, String alg, String iv, String aad) {
        this(credentials, alg, iv, aad);
        this.credentialsAlg = credentialsAlg;
    }

    public EncryptOptions(Object credentials, String credentialsAlg, String alg, String iv, String aad, BigParamEncryptMode bigParamEncryptMode) {
        this(credentials, credentialsAlg, alg, iv, aad);
        this.bigParamEncryptMode = bigParamEncryptMode;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Object credentials) {
        this.credentials = credentials;
    }

    public String getEncryptedCredentials() {
        return this.encryptedCredentials;
    }

    public void setEncryptedCredentials(String encryptedCredentials) {
        this.encryptedCredentials = encryptedCredentials;
    }

    public String getCredentialsAlg() {
        return this.credentialsAlg;
    }

    public void setCredentialsAlg(String credentialsAlg) {
        this.credentialsAlg = credentialsAlg;
    }

    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getAad() {
        return this.aad;
    }

    public void setAad(String aad) {
        this.aad = aad;
    }

    public BigParamEncryptMode getBigParamEncryptMode() {
        return this.bigParamEncryptMode;
    }

    public void setBigParamEncryptMode(BigParamEncryptMode bigParamEncryptMode) {
        this.bigParamEncryptMode = bigParamEncryptMode;
    }

    public Map<String, Object> getEnhancerInfo() {
        return Collections.unmodifiableMap(this.enhancerInfo);
    }

    public void enhance(String key, Object value) {
        this.enhancerInfo.put(key, value);
    }

    public EncryptOptions copy() {
        EncryptOptions copy = new EncryptOptions();
        copy.credentials = this.credentials;
        copy.encryptedCredentials = this.encryptedCredentials;
        copy.credentialsAlg = this.credentialsAlg;
        copy.alg = this.alg;
        copy.iv = this.iv;
        copy.aad = this.aad;
        copy.bigParamEncryptMode = this.bigParamEncryptMode;
        return copy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

