/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.sentinel;

import com.yeepay.shade.com.alibaba.csp.sentinel.Constants;
import com.yeepay.shade.com.alibaba.csp.sentinel.Entry;
import com.yeepay.shade.com.alibaba.csp.sentinel.EntryType;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.Context;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.ContextUtil;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.NullContext;
import com.yeepay.shade.com.alibaba.csp.sentinel.init.InitExecutor;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.RecordLog;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.SlotChainProvider;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.BlockException;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Queues;
import com.yeepay.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.base.cache.YopDegradeRuleHelper;
import com.yeepay.yop.sdk.invoke.model.UriResource;
import com.yeepay.yop.sdk.sentinel.YopEntry;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSph {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSph.class);
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final YopSph yopSph = new YopSph();
    private static final ThreadPoolExecutor BLOCKED_SWEEPER = new ThreadPoolExecutor(2, 20, 3L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue(1000), new ThreadFactoryBuilder().setNameFormat("yop-blocked-resource-sweeper-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final Object[] OBJECTS0;
    private static volatile Map<ResourceWrapper, ProcessorSlotChain> chainMap;
    private static final Object LOCK;

    public static YopSph getInstance() {
        return yopSph;
    }

    private Entry entryWithPriority(ResourceWrapper resourceWrapper, int count, boolean prioritized, Object ... args) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return new YopEntry(resourceWrapper, null, context);
        }
        if (context == null) {
            context = InternalContextUtil.internalEnter("sentinel_default_context");
        }
        if (!Constants.ON) {
            return new YopEntry(resourceWrapper, null, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return new YopEntry(resourceWrapper, null, context);
        }
        YopEntry e = new YopEntry(resourceWrapper, chain, context);
        try {
            chain.entry(context, resourceWrapper, null, count, prioritized, args);
        }
        catch (BlockException e1) {
            ((Entry)e).exit(count, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.info("Sentinel unexpected exception", e1);
        }
        return e;
    }

    public Entry entry(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        return this.entryWithPriority(resourceWrapper, count, false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessorSlot<Object> lookProcessChain(ResourceWrapper resourceWrapper) {
        StringResourceWrapper realResource;
        ProcessorSlotChain chain;
        String resourceName = resourceWrapper.getName();
        if (resourceName.contains("####")) {
            String[] split = resourceName.split("####");
            resourceName = split[split.length - 1];
        }
        if ((chain = chainMap.get(realResource = new StringResourceWrapper(resourceName, resourceWrapper.getEntryType(), resourceWrapper.getResourceType()))) == null) {
            Object object = LOCK;
            synchronized (object) {
                chain = chainMap.get(realResource);
                if (chain == null) {
                    if (chainMap.size() >= 6000) {
                        return null;
                    }
                    chain = SlotChainProvider.newSlotChain();
                    HashMap<ResourceWrapper, ProcessorSlotChain> newMap = new HashMap<ResourceWrapper, ProcessorSlotChain>(chainMap.size() + 1);
                    newMap.putAll(chainMap);
                    newMap.put(resourceWrapper, chain);
                    chainMap = newMap;
                }
            }
        }
        return chain;
    }

    public Entry entry(String name) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    static {
        InitExecutor.doInit();
        OBJECTS0 = new Object[0];
        chainMap = new HashMap<ResourceWrapper, ProcessorSlotChain>();
        LOCK = new Object();
    }

    public static class BlockResourcePool {
        private static final Map<String, List<URI>> serverBlockList = Maps.newConcurrentMap();
        private static final Map<String, AtomicLong> serverBLockSequence = Maps.newConcurrentMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UriResource select(String serverType, URI mainServer) {
            rwl.readLock().lock();
            try {
                URI oldestFailServer = null;
                List<URI> failedServers = serverBlockList.get(serverType);
                if (null != failedServers && !failedServers.isEmpty()) {
                    oldestFailServer = failedServers.get(0);
                }
                if (null == oldestFailServer) {
                    oldestFailServer = mainServer;
                }
                UriResource uriResource = this.initServer(serverType, oldestFailServer);
                return uriResource;
            }
            finally {
                rwl.readLock().unlock();
            }
        }

        private UriResource initServer(String serverType, URI oldestFailServer) {
            String blockSequenceKey = this.getBlockSequenceKey(serverType, oldestFailServer);
            AtomicLong blockSequence = serverBLockSequence.computeIfAbsent(blockSequenceKey, p -> new AtomicLong(0L));
            String resourcePrefix = this.getBlockResourcePrefix(serverType, blockSequence.get());
            return new UriResource(UriResource.ResourceType.BLOCKED, resourcePrefix, oldestFailServer);
        }

        private String parseBlockServerType(String blockResourcePrefix) {
            return blockResourcePrefix.split(",")[0];
        }

        private Long parseBLockSequence(String blockResourcePrefix) {
            return Long.valueOf(blockResourcePrefix.split(",")[1]);
        }

        private String getBlockResourcePrefix(String serverType, Long blockSequence) {
            return serverType + "," + blockSequence;
        }

        private String getBlockSequenceKey(String serverType, URI server) {
            return serverType + "," + server.toString();
        }

        public void onServerStatusChange(UriResource uriResource, CircuitBreaker.State prevState, CircuitBreaker.State newState, DegradeRule rule, Set<String> serverRootTypes) {
            this.updateBlockedStatus(uriResource, serverRootTypes, !CircuitBreaker.State.OPEN.equals((Object)newState));
            if (newState.equals((Object)CircuitBreaker.State.OPEN) && UriResource.ResourceType.BLOCKED.equals((Object)uriResource.getResourceType())) {
                this.asyncDiscardOldServers(uriResource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBlockedStatus(UriResource uriResource, Set<String> serverRootTypes, boolean successInvoked) {
            rwl.writeLock().lock();
            try {
                URI serverRoot = uriResource.getResource();
                for (String serverRootType : serverRootTypes) {
                    List blockedServers = serverBlockList.computeIfAbsent(serverRootType, p -> new ArrayList());
                    blockedServers.removeIf(serverRoot::equals);
                    if (successInvoked) {
                        blockedServers.add(0, serverRoot);
                        continue;
                    }
                    blockedServers.add(serverRoot);
                }
                if (UriResource.ResourceType.BLOCKED.equals((Object)uriResource.getResourceType()) && !successInvoked) {
                    String serverRootType = this.parseBlockServerType(uriResource.getResourcePrefix());
                    serverBLockSequence.computeIfAbsent(this.getBlockSequenceKey(serverRootType, uriResource.getResource()), p -> new AtomicLong(0L)).getAndAdd(1L);
                }
            }
            finally {
                rwl.writeLock().unlock();
            }
        }

        private void asyncDiscardOldServers(UriResource uriResource) {
            BLOCKED_SWEEPER.submit(() -> {
                try {
                    String resource = uriResource.computeResourceKey();
                    YopDegradeRuleHelper.removeDegradeRule(resource);
                }
                catch (Exception e) {
                    LOGGER.warn("blocked sweeper failed, ex:", e);
                }
            });
        }
    }

    private static final class InternalContextUtil
    extends ContextUtil {
        private InternalContextUtil() {
        }

        static Context internalEnter(String name) {
            return InternalContextUtil.trueEnter(name, "");
        }

        static Context internalEnter(String name, String origin) {
            return InternalContextUtil.trueEnter(name, origin);
        }
    }
}

