/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CertificateCredentials;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqSupport;
import com.yeepay.yop.sdk.base.auth.signer.YopSignerFactory;
import com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.base.cache.EncryptOptionsCache;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RequestAnalyzer;
import com.yeepay.yop.sdk.internal.RequestEncryptor;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.service.common.callback.YopCallback;
import com.yeepay.yop.sdk.service.common.callback.YopCallbackRequest;
import com.yeepay.yop.sdk.service.common.callback.YopCallbackRequestMarshaller;
import com.yeepay.yop.sdk.service.common.callback.YopCallbackResponse;
import com.yeepay.yop.sdk.service.common.callback.handler.YopCallbackHandlerFactory;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopCallbackProtocol;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopCallbackProtocolFactory;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopSm2CallbackProtocol;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopCallbackEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopCallbackEngine.class);

    public static YopCallbackRequest build(YopRequest request) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        Request<YopRequest> marshalled = YopCallbackRequestMarshaller.getInstance().marshall(request);
        AuthorizationReq authorizationReq = AuthorizationReqSupport.getAuthorizationReq(request.getRequestConfig().getSecurityReq());
        if (null == authorizationReq) {
            throw new YopClientException("no authenticate req defined");
        }
        YopRequestConfig requestConfig = request.getRequestConfig();
        YopCredentials<?> credential = RequestAnalyzer.getCredentials(requestConfig, authorizationReq);
        if (RequestAnalyzer.isEncryptSupported(credential, requestConfig)) {
            RequestEncryptor.encrypt(marshalled, RequestAnalyzer.getEncryptor(requestConfig), EncryptOptionsCache.loadEncryptOptions(credential.getAppKey(), requestConfig.getEncryptAlg(), requestConfig.getServerRoot()).get());
        }
        YopSignerFactory.getSigner(authorizationReq.getSignerType()).sign(marshalled, credential, authorizationReq.getSignOptions());
        YopCallbackRequest callbackRequest = YopCallbackRequest.fromYopRequest(marshalled);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("YopCallbackRequest build:{}", (Object)callbackRequest);
        }
        return callbackRequest;
    }

    public static YopCallback parse(YopCallbackRequest request) {
        YopCallback parsed = YopCallbackProtocolFactory.fromRequest(request).parse();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("YopCallbackRequest decrypted:{}", (Object)parsed);
        }
        return parsed;
    }

    public static YopCallbackResponse handle(YopCallbackRequest request) {
        YopCallbackResponse result;
        YopCallbackProtocol protocol = YopCallbackProtocolFactory.fromRequest(request);
        YopCallback callback = protocol.parse();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("YopCallbackRequest decrypted:{}", (Object)callback);
        }
        try {
            YopCallbackHandlerFactory.getHandler(callback.getType()).handle(callback);
            result = YopCallbackResponse.success();
        }
        catch (Throwable e) {
            LOGGER.error("error when handle YopCallbackRequest, ex:", e);
            result = YopCallbackResponse.fail(e.getMessage());
        }
        YopCallbackEngine.signIfNecessary(result, protocol, callback);
        return result;
    }

    private static void signIfNecessary(YopCallbackResponse response, YopCallbackProtocol protocol, YopCallback callback) {
        try {
            if (!(protocol instanceof YopSm2CallbackProtocol)) {
                return;
            }
            response.setContentType(YopContentType.JSON);
            HashMap<String, String> headers = Maps.newHashMap();
            YopCredentials<?> credentials = YopCredentialsProviderRegistry.getProvider().getCredentials(callback.getAppKey(), CertTypeEnum.SM2.name());
            SignOptions signOptions = AuthorizationReqSupport.getAuthorizationReq("YOP-SM2-SM3").getSignOptions();
            headers.put("x-yop-sign", YopSignProcessorFactory.getSignProcessor(CertTypeEnum.SM2.name()).doSign(response.getBody().replaceAll("[ \t\n]", ""), (CredentialsItem)credentials.getCredential(), signOptions));
            if (credentials instanceof CertificateCredentials) {
                headers.put("x-yop-sign-serial-no", ((CertificateCredentials)((Object)credentials)).getSerialNo());
            }
            response.setHeaders(headers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("YopCallbackResponse signed:{}", (Object)response);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("error when sign the YopCallbackResponse, ex:", e);
        }
    }
}

