/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.lang3.builder.ToStringBuilder;
import com.yeepay.shade.org.apache.commons.lang3.builder.ToStringStyle;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YopCallbackRequest
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String httpPath;
    private String httpMethod;
    private YopContentType contentType;
    private Map<String, String> headers;
    private Map<String, String> canonicalHeaders;
    private Map<String, List<String>> params = Maps.newHashMap();
    private Object content;
    private String platformServerRoot;

    public YopCallbackRequest(String httpPath, String httpMethod) {
        this.httpPath = httpPath;
        this.httpMethod = httpMethod;
    }

    public static YopCallbackRequest fromYopRequest(Request<YopRequest> yopRequest) {
        YopRequest originRequest = yopRequest.getOriginalRequestObject();
        YopCallbackRequest callbackRequest = new YopCallbackRequest(originRequest.getApiUri(), originRequest.getHttpMethod());
        callbackRequest.setContentType(yopRequest.getContentType());
        callbackRequest.setHeaders(yopRequest.getHeaders());
        callbackRequest.setContent(yopRequest.getContent());
        callbackRequest.setPlatformServerRoot(originRequest.getRequestConfig().getServerRoot());
        return callbackRequest;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public YopContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCanonicalHeaders() {
        return this.canonicalHeaders;
    }

    public Map<String, List<String>> getParams() {
        return this.params;
    }

    public Object getContent() {
        return this.content;
    }

    public String getPlatformServerRoot() {
        return this.platformServerRoot;
    }

    public String getParam(String name) {
        List<String> values;
        if (MapUtils.isNotEmpty(this.params) && CollectionUtils.isNotEmpty(values = this.params.get(name))) {
            return values.get(0);
        }
        return null;
    }

    public YopCallbackRequest setHttpPath(String httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public YopCallbackRequest setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public YopCallbackRequest setContentType(YopContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public YopCallbackRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        if (MapUtils.isNotEmpty(headers)) {
            HashMap<String, String> canonicalHeaders = Maps.newHashMapWithExpectedSize(headers.size());
            headers.forEach((k, v) -> canonicalHeaders.put(k.trim().toLowerCase(), (String)v));
            this.canonicalHeaders = canonicalHeaders;
        }
        return this;
    }

    public YopCallbackRequest addParam(String name, String value) {
        this.params.computeIfAbsent(name, p -> Lists.newLinkedList()).add(value);
        return this;
    }

    public YopCallbackRequest setParams(Map<String, List<String>> params) {
        this.params = params;
        return this;
    }

    public YopCallbackRequest setContent(Object content) {
        this.content = content;
        return this;
    }

    public YopCallbackRequest setPlatformServerRoot(String platformServerRoot) {
        this.platformServerRoot = platformServerRoot;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

