/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.config.IllegalConfigFormatException;
import com.yeepay.yop.sdk.exception.config.MissingConfigException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;

public class CheckUtils {
    private static final Pattern API_URI_PATTERN = Pattern.compile("/((rest|yos)/.+)?");

    public static void checkCustomSDKConfig(YopFileSdkConfig yopFileSdkConfig) {
        if (StringUtils.isEmpty(yopFileSdkConfig.getAppKey())) {
            throw new MissingConfigException("appKey", "appKey is empty");
        }
        if (StringUtils.isNotEmpty(yopFileSdkConfig.getServerRoot())) {
            try {
                new URL(yopFileSdkConfig.getServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormatException("serverRoot", "serverRoot is illegal");
            }
        }
        if (StringUtils.isNotEmpty(yopFileSdkConfig.getYosServerRoot())) {
            try {
                new URL(yopFileSdkConfig.getYosServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormatException("yosServerRoot", "yosServerRoot is illegal");
            }
        }
        if (StringUtils.isNotEmpty(yopFileSdkConfig.getSandboxServerRoot())) {
            try {
                new URL(yopFileSdkConfig.getSandboxServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormatException("sandboxServerRoot", "sandboxServerRoot is illegal");
            }
        }
    }

    public static void checkApiUri(String apiUri) {
        if (StringUtils.isNotBlank(apiUri) && API_URI_PATTERN.matcher(apiUri).matches()) {
            return;
        }
        throw new YopClientException("ReqParam Illegal, ApiUri, value:" + apiUri);
    }

    public static void checkCallbackUri(String callbackUri) {
        if (StringUtils.isNotBlank(callbackUri)) {
            return;
        }
        throw new YopClientException("callbackUri is illegal, param:" + callbackUri);
    }

    public static URI checkServerRoot(String serverRoot) {
        URI uri;
        if (null == serverRoot) {
            return null;
        }
        try {
            uri = new URI(serverRoot);
        }
        catch (Exception e) {
            throw new YopClientException("request serverRoot is illegal, value:" + serverRoot);
        }
        if (!StringUtils.equalsAny(uri.getScheme(), "http", "https")) {
            throw new YopClientException("unsupported request scheme, value:" + uri.getScheme());
        }
        return uri;
    }
}

