/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.yeepay.shade.org.joda.time.DateTime;
import com.yeepay.shade.org.joda.time.DateTimeZone;
import com.yeepay.shade.org.joda.time.LocalDate;
import com.yeepay.shade.org.joda.time.format.DateTimeFormat;
import com.yeepay.shade.org.joda.time.format.DateTimeFormatter;
import com.yeepay.shade.org.joda.time.format.ISODateTimeFormat;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter alternateIso8601DateFormat = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter compressedIso8601DateTimeFormat = ISODateTimeFormat.basicDateTimeNoMillis().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter compressedIso8601DateFormat = ISODateTimeFormat.basicDate().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter simpleDateFromat = ISODateTimeFormat.date();
    private static final DateTimeFormatter simpleDateTimeFormat = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    public static Date parseIso8601Date(String dateString) {
        try {
            return iso8601DateFormat.parseDateTime(dateString).toDate();
        }
        catch (IllegalArgumentException e) {
            return alternateIso8601DateFormat.parseDateTime(dateString).toDate();
        }
    }

    public static String formatIso8601Date(Date date) {
        return iso8601DateFormat.print(new DateTime(date));
    }

    public static Date parseAlternateIso8601Date(String dateString) {
        return alternateIso8601DateFormat.parseDateTime(dateString).toDate();
    }

    public static String formatAlternateIso8601Date(Date date) {
        return alternateIso8601DateFormat.print(new DateTime(date));
    }

    public static Date parseRfc822Date(String dateString) {
        return rfc822DateFormat.parseDateTime(dateString).toDate();
    }

    public static String formatRfc822Date(Date date) {
        return rfc822DateFormat.print(new DateTime(date));
    }

    public static Date parseCompressedIso8601Date(String dateString) {
        return compressedIso8601DateTimeFormat.parseDateTime(dateString).toDate();
    }

    public static String formatCompressedIso8601Date(Date date) {
        return compressedIso8601DateFormat.print(new DateTime(date));
    }

    public static String formatCompressedIso8601Date(LocalDate date) {
        return compressedIso8601DateFormat.print(date);
    }

    public static String formatCompressedIso8601DateTime(Date date) {
        return compressedIso8601DateTimeFormat.print(new DateTime(date));
    }

    public static String formatCompressedIso8601DateTime(DateTime dateTime) {
        return compressedIso8601DateTimeFormat.print(dateTime);
    }

    public static String formatSimpleDateTime(DateTime dateTime) {
        return simpleDateTimeFormat.print(dateTime);
    }

    public static DateTime parseSimpleDateTime(String dateTimeString) {
        return simpleDateTimeFormat.parseDateTime(dateTimeString);
    }

    public static String formatSimpleDate(LocalDate date) {
        return simpleDateFromat.print(date);
    }

    public static DateTime parseSimpleDate(String dateString) {
        return simpleDateFromat.parseDateTime(dateString);
    }
}

