/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.yeepay.yop.sdk.exception.YopClientException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Holder<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Holder.class);
    private final FutureTask<V> futureTask;

    public Holder(Callable<V> initCallable) {
        this.futureTask = new FutureTask<V>(initCallable);
    }

    public V getValue() {
        this.futureTask.run();
        try {
            return this.futureTask.get();
        }
        catch (InterruptedException e) {
            throw new YopClientException("SystemError, ThreadInterrupted, ex:", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new YopClientException("UnexpectedError, ex:", cause);
        }
    }
}

