/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.yeepay.shade.com.google.common.base.Joiner;
import com.yeepay.shade.com.google.common.base.Preconditions;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.Protocol;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final BitSet URI_UNRESERVED_CHARACTERS;
    private static final String[] PERCENT_ENCODED_STRINGS;
    private static final Joiner queryStringJoiner;
    private static final boolean HTTP_VERBOSE;
    private static final Set<YopContentType> FORM_CONTENT_TYPES;

    public static boolean isHttpVerbose() {
        return HTTP_VERBOSE;
    }

    public static String normalizePath(String path) {
        return HttpUtils.normalize(path).replace("%2F", "/");
    }

    public static String normalize(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            for (byte b : value.getBytes(DEFAULT_ENCODING)) {
                if (URI_UNRESERVED_CHARACTERS.get(b & 0xFF)) {
                    builder.append((char)b);
                    continue;
                }
                builder.append(PERCENT_ENCODED_STRINGS[b & 0xFF]);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateHostHeader(URI uri) {
        String host = uri.getHost();
        if (HttpUtils.isUsingNonDefaultPort(uri)) {
            host = host + ":" + uri.getPort();
        }
        return host;
    }

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port <= 0) {
            return false;
        }
        if (scheme.equals(Protocol.HTTP.toString())) {
            return port != Protocol.HTTP.getDefaultPort();
        }
        if (scheme.equals(Protocol.HTTPS.toString())) {
            return port != Protocol.HTTPS.getDefaultPort();
        }
        return false;
    }

    public static String getCanonicalQueryString(Map<String, List<String>> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList<String> parameterStrings = Lists.newArrayList();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (forSignature && "Authorization".equalsIgnoreCase(entry.getKey())) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull(key, "parameter key should not be null");
            List<String> value = entry.getValue();
            if (value == null) {
                if (forSignature) {
                    parameterStrings.add(HttpUtils.normalize(key) + '=');
                    continue;
                }
                parameterStrings.add(HttpUtils.normalize(key));
                continue;
            }
            for (String item : value) {
                parameterStrings.add(HttpUtils.normalize(key) + '=' + HttpUtils.normalize(item));
            }
        }
        Collections.sort(parameterStrings);
        return queryStringJoiner.join(parameterStrings);
    }

    public static URI appendUri(URI baseUri, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(baseUri.toASCIIString());
        for (String path : pathComponents) {
            if (path == null || path.length() <= 0) continue;
            if ((path = HttpUtils.normalizePath(path)).startsWith("/")) {
                if (builder.charAt(builder.length() - 1) == '/') {
                    builder.setLength(builder.length() - 1);
                }
            } else if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(path);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    public static boolean usePayloadForQueryParameters(Request<? extends BaseRequest> request) {
        boolean requestIsPOST = HttpMethodName.POST.equals((Object)request.getHttpMethod());
        boolean requestHasNoPayload = request.getContent() == null;
        return requestIsPOST && requestHasNoPayload;
    }

    public static String encodeParameters(Request<? extends BaseRequest> request, Boolean forSignature) {
        Map<Object, Object> requestParams;
        if (MapUtils.isEmpty(request.getParameters())) {
            return null;
        }
        if (BooleanUtils.isTrue(forSignature)) {
            requestParams = Maps.newTreeMap();
            requestParams.putAll(request.getParameters());
        } else {
            requestParams = Collections.unmodifiableMap(request.getParameters());
        }
        ArrayList<String> encodedNameValuePair = Lists.newArrayListWithExpectedSize(requestParams.size());
        for (Map.Entry<Object, Object> entry : requestParams.entrySet()) {
            String paramName = (String)entry.getKey();
            for (String paramValue : (List)entry.getValue()) {
                try {
                    encodedNameValuePair.add(HttpUtils.toNameValuePair(forSignature, paramName, paramValue));
                }
                catch (UnsupportedEncodingException e) {
                    throw new YopClientException("ReqParam Illegal, Charset NotSuppport, name:" + paramName + ",value:" + paramValue, e);
                }
            }
        }
        return queryStringJoiner.join(encodedNameValuePair);
    }

    private static String toNameValuePair(Boolean forSignature, String paramName, String paramValue) throws UnsupportedEncodingException {
        if (null != paramValue) {
            String encodedParamValue = BooleanUtils.isTrue(forSignature) ? paramValue : URLEncoder.encode(paramValue, DEFAULT_ENCODING);
            return URLEncoder.encode(paramName, DEFAULT_ENCODING) + "=" + URLEncoder.encode(encodedParamValue, DEFAULT_ENCODING);
        }
        return URLEncoder.encode(paramName, DEFAULT_ENCODING);
    }

    public static boolean isJsonResponse(String contentType) {
        return StringUtils.startsWith(contentType, "application/json");
    }

    public static boolean isJsonContentType(Request<? extends BaseRequest> request) {
        return null != request && (YopContentType.JSON.equals((Object)request.getContentType()) || MapUtils.isNotEmpty(request.getHeaders()) && StringUtils.startsWith(request.getHeaders().get("Content-Type"), "application/json"));
    }

    public static String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        return path.startsWith("/") ? HttpUtils.normalizePath(path) : "/" + HttpUtils.normalizePath(path);
    }

    public static boolean useEmptyAsCanonicalQueryString(String httpMethod, YopContentType contentType) {
        boolean requestIsForm;
        boolean requestIsPost = StringUtils.equalsIgnoreCase(httpMethod, HttpMethodName.POST.name());
        boolean bl = requestIsForm = null != contentType && FORM_CONTENT_TYPES.contains((Object)contentType);
        return requestIsPost && requestIsForm;
    }

    static {
        int i;
        URI_UNRESERVED_CHARACTERS = new BitSet();
        PERCENT_ENCODED_STRINGS = new String[256];
        queryStringJoiner = Joiner.on('&');
        HTTP_VERBOSE = Boolean.parseBoolean(System.getProperty("yop.sdk.http", "false"));
        FORM_CONTENT_TYPES = Sets.newHashSet(YopContentType.FORM_URL_ENCODE, YopContentType.MULTIPART_FORM);
        for (i = 97; i <= 122; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        URI_UNRESERVED_CHARACTERS.set(45);
        URI_UNRESERVED_CHARACTERS.set(46);
        URI_UNRESERVED_CHARACTERS.set(95);
        URI_UNRESERVED_CHARACTERS.set(126);
        for (i = 0; i < PERCENT_ENCODED_STRINGS.length; ++i) {
            HttpUtils.PERCENT_ENCODED_STRINGS[i] = String.format("%%%02X", i);
        }
    }
}

