/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.base.security.cert.X509CertSupportFactory;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class X509CertUtils {
    public static void verifyCertificate(CertTypeEnum certType, PublicKey issuerPubKey, X509Certificate cert) throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509CertUtils.checkCertDate(cert);
        if (null != issuerPubKey) {
            X509CertSupportFactory.getSupport(certType.getValue()).verifyCertificate(issuerPubKey, cert);
        }
    }

    public static boolean checkCertDate(X509Certificate certificate) throws CertificateExpiredException, CertificateNotYetValidException {
        YopCertStore yopCertStore = X509CertUtils.globalCertStoreConfig();
        long validAfterExpire = X509CertUtils.getValidAfterExpire(yopCertStore);
        long refreshBeforeExpire = X509CertUtils.getRefreshBeforeExpire(yopCertStore);
        Date now = new Date();
        long time24HoursAgo = now.getTime() - validAfterExpire;
        if (time24HoursAgo > certificate.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + certificate.getNotAfter().getTime());
        }
        if (now.getTime() < certificate.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + certificate.getNotBefore().getTime());
        }
        long time72HoursAfter = now.getTime() + refreshBeforeExpire;
        return time72HoursAfter > certificate.getNotAfter().getTime();
    }

    private static long getRefreshBeforeExpire(YopCertStore yopCertStore) {
        if (null != yopCertStore && null != yopCertStore.getRefreshBeforeExpirePeriod() && yopCertStore.getRefreshBeforeExpirePeriod() > 0L) {
            return yopCertStore.getRefreshBeforeExpirePeriod();
        }
        return 259200000L;
    }

    private static long getValidAfterExpire(YopCertStore yopCertStore) {
        if (null != yopCertStore && null != yopCertStore.getValidAfterExpirePeriod() && yopCertStore.getValidAfterExpirePeriod() > 0L) {
            return yopCertStore.getValidAfterExpirePeriod();
        }
        return 86400000L;
    }

    public static X509Certificate getX509Certificate(CertTypeEnum certType, byte[] certBytes) throws CertificateException, NoSuchProviderException {
        ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
        return X509CertUtils.getX509Certificate(certType, bais);
    }

    public static X509Certificate getX509Certificate(CertTypeEnum certType, InputStream is) throws CertificateException, NoSuchProviderException {
        return X509CertSupportFactory.getSupport(certType.getValue()).generate(is);
    }

    private static YopCertStore globalCertStoreConfig() {
        return YopSdkConfigProviderRegistry.getProvider().getConfig().getYopCertStore();
    }

    public static String parseToHex(String decimalSerialNo) {
        if (StringUtils.isEmpty(decimalSerialNo) || 10 >= decimalSerialNo.length()) {
            return decimalSerialNo;
        }
        return Long.toHexString(Long.parseLong(decimalSerialNo));
    }

    public static String parseToDecimal(String hexSerialNo) {
        if (StringUtils.isEmpty(hexSerialNo) || 10 != hexSerialNo.length()) {
            return hexSerialNo;
        }
        return Long.valueOf(hexSerialNo, 16).toString();
    }
}

