/*
 * Decompiled with CFR 0.152.
 */
package com.yeliheng.eventbus;

import com.yeliheng.eventbus.EventBusThreadFactory;
import com.yeliheng.eventbus.SubscriberFinder;
import com.yeliheng.eventbus.enums.ThreadType;
import com.yeliheng.eventbus.interfaces.IEvent;
import com.yeliheng.eventbus.interfaces.ISubscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    public static final Logger logger = LoggerFactory.getLogger(EventBus.class);
    private static final Map<Class<?>, List<ISubscriber>> subscriberMap = new HashMap();
    private static final Map<Class<?>, Boolean> subscriberStatusMap = new HashMap();
    private static final EventBus instance = new EventBus();
    private static final EventBusThreadFactory factory = new EventBusThreadFactory(1);
    public static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    public static final int MAX_POOL_SIZE = CORE_POOL_SIZE * 2;
    private static final Executor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);

    private EventBus() {
        if (instance != null) {
            throw new RuntimeException("EventBus is a singleton");
        }
    }

    public static EventBus getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object subscriber) {
        Objects.requireNonNull(subscriber);
        if (subscriberStatusMap.get(subscriber.getClass()) != null) {
            logger.warn(String.format("Subscriber %s has already been registered", subscriber.getClass()));
            return;
        }
        Map<Class<?>, List<ISubscriber>> registeredSubs = SubscriberFinder.find(subscriber);
        EventBus eventBus = this;
        synchronized (eventBus) {
            if (!registeredSubs.isEmpty()) {
                subscriberStatusMap.put(subscriber.getClass(), true);
                logger.info(String.format("Registered: %s", subscriber.getClass()));
            }
            registeredSubs.forEach((subscriberClass, subscribers) -> subscriberMap.computeIfAbsent((Class<?>)subscriberClass, k -> new ArrayList()).addAll(subscribers));
        }
    }

    public void unregister(Object subscriber) {
        Objects.requireNonNull(subscriber);
        if (subscriberMap != null && !subscriberMap.isEmpty()) {
            subscriberMap.forEach((subscriberClass, subscribers) -> {
                if (subscribers == null || subscribers.isEmpty()) {
                    logger.warn(String.format("Subscriber %s was not registered", subscriber.getClass()));
                    return;
                }
                subscribers.removeIf(sub -> sub.getSubscriber() == subscriber);
                subscriberStatusMap.remove(subscriber.getClass());
            });
        } else {
            logger.warn(String.format("Subscriber %s was not registered", subscriber.getClass()));
        }
    }

    public static void post(IEvent event) {
        Objects.requireNonNull(event);
        Class<?> clazz = event.getClass();
        List<ISubscriber> subscribers = subscriberMap.get(clazz);
        if (subscribers == null || subscribers.isEmpty()) {
            return;
        }
        for (ISubscriber subscriber : subscribers) {
            if (subscriber.getThreadType() == ThreadType.ASYNC) {
                executor.execute(() -> subscriber.invoke(event));
                continue;
            }
            subscriber.invoke(event);
        }
    }
}

