/*
 * Decompiled with CFR 0.152.
 */
package com.yeliheng.eventbus;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusThreadFactory
implements ThreadFactory {
    public final Logger logger = LoggerFactory.getLogger(EventBusThreadFactory.class);
    private final int poolNumber;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    EventBusThreadFactory(int poolNumber) {
        this.poolNumber = poolNumber;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String threadName = "eventbus-" + this.poolNumber + "-thread-" + this.threadNumber.getAndIncrement();
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(false);
        thread.setPriority(5);
        thread.setUncaughtExceptionHandler((t, e) -> this.logger.warn(t.toString() + e.toString()));
        return thread;
    }
}

