/*
 * Decompiled with CFR 0.152.
 */
package com.yeliheng.eventbus;

import com.yeliheng.eventbus.Subscription;
import com.yeliheng.eventbus.annotations.Subscribe;
import com.yeliheng.eventbus.interfaces.IEvent;
import com.yeliheng.eventbus.interfaces.ISubscriber;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscriberFinder {
    public static Map<Class<?>, List<ISubscriber>> find(Object subscriber) {
        Method[] methods;
        HashMap subscriberMap = new HashMap();
        Class<?> clazz = subscriber.getClass();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Subscribe annotation = method.getAnnotation(Subscribe.class);
            if (annotation == null) continue;
            SubscriberFinder.checkSubscriberMethod(method);
            Class<?>[] parameterTypes = method.getParameterTypes();
            subscriberMap.computeIfAbsent(parameterTypes[0], k -> new ArrayList()).add(new Subscription(subscriber, method, annotation.threadType()));
        }
        return subscriberMap;
    }

    private static void checkSubscriberMethod(Method method) {
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException(String.format("[%s] Subscriber method: %s must have exactly 1 parameter", method.getDeclaringClass(), method.getName()));
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException(String.format("[%s] Subscriber method: %s must have a void return type", method.getDeclaringClass(), method.getName()));
        }
        if (!IEvent.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException(String.format("[%s] Subscriber method: %s must have a parameter type of IEvent", method.getDeclaringClass(), method.getName()));
        }
    }
}

