/*
 * Decompiled with CFR 0.152.
 */
package com.yeliheng.eventbus;

import com.yeliheng.eventbus.enums.ThreadType;
import com.yeliheng.eventbus.interfaces.IEvent;
import com.yeliheng.eventbus.interfaces.ISubscriber;
import java.lang.reflect.Method;

public class Subscription
implements ISubscriber {
    private final Object subscriber;
    private final Method method;
    private final ThreadType threadType;

    public Subscription(Object subscriber, Method method, ThreadType threadType) {
        this.subscriber = subscriber;
        this.method = method;
        this.threadType = threadType;
    }

    @Override
    public ThreadType getThreadType() {
        return this.threadType;
    }

    @Override
    public void invoke(IEvent event) {
        try {
            this.method.invoke(this.subscriber, event);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception - " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public Object getSubscriber() {
        return this.subscriber;
    }

    public Method getMethod() {
        return this.method;
    }
}

